/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.KeyboardEvent;
import java.io.IOException;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.htmlunit.KeyboardModifiersState;

public class HtmlUnitKeyboard
implements Keyboard {
    private KeyboardModifiersState modifiersState = new KeyboardModifiersState();
    private final HtmlUnitDriver parent;

    HtmlUnitKeyboard(HtmlUnitDriver parent) {
        this.parent = parent;
    }

    private HtmlUnitWebElement getElementToSend(WebElement toElement) {
        WebElement sendToElement = toElement;
        if (sendToElement == null) {
            sendToElement = this.parent.switchTo().activeElement();
        }
        return (HtmlUnitWebElement)sendToElement;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElem = this.getElementToSend(toElement);
        htmlElem.sendKeys(keysToSend);
    }

    public void sendKeys(HtmlElement element, String currentValue, InputKeysContainer keysToSend) {
        keysToSend.setCapitalization(this.modifiersState.isShiftPressed());
        if (this.parent.isJavascriptEnabled() && !(element instanceof HtmlFileInput)) {
            if (element instanceof HtmlTextArea) {
                String text = ((HtmlTextArea)element).getText();
                ((HtmlTextArea)element).setSelectionStart(text.length());
                ((HtmlTextArea)element).setSelectionEnd(text.length());
            }
            try {
                element.type(keysToSend.toString());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        } else if (element instanceof HtmlInput) {
            HtmlInput input = (HtmlInput)element;
            input.setValueAttribute((currentValue == null ? "" : currentValue) + keysToSend.toString());
        } else if (element instanceof HtmlTextArea) {
            ((HtmlTextArea)element).setText((currentValue == null ? "" : currentValue) + keysToSend.toString());
        } else {
            throw new UnsupportedOperationException("You may only set the value of elements that are input elements");
        }
    }

    public void pressKey(Keys keyToPress) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        this.modifiersState.storeKeyDown(keyToPress);
        htmlElement.sendKeyDownEvent(keyToPress);
    }

    public void releaseKey(Keys keyToRelease) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        this.modifiersState.storeKeyUp(keyToRelease);
        htmlElement.sendKeyUpEvent(keyToRelease);
    }

    public void performSingleKeyAction(HtmlElement element, Keys modifierKey, String eventDescription) {
        boolean shiftKey = modifierKey.equals((Object)Keys.SHIFT);
        boolean ctrlKey = modifierKey.equals((Object)Keys.CONTROL);
        boolean altKey = modifierKey.equals((Object)Keys.ALT);
        KeyboardEvent keyEvent = new KeyboardEvent((DomNode)element, eventDescription, 0, shiftKey, ctrlKey, altKey);
        element.fireEvent((Event)keyEvent);
    }

    public boolean isShiftPressed() {
        return this.modifiersState.isShiftPressed();
    }

    public boolean isCtrlPressed() {
        return this.modifiersState.isCtrlPressed();
    }

    public boolean isAltPressed() {
        return this.modifiersState.isAltPressed();
    }
}

