/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeBinary;
import org.openqa.selenium.chrome.ChromeCommandExecutor;
import org.openqa.selenium.chrome.ChromeExtension;
import org.openqa.selenium.chrome.ChromeProfile;
import org.openqa.selenium.chrome.ChromeWebElement;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeDriver
extends RemoteWebDriver
implements TakesScreenshot,
FindsByCssSelector {
    public ChromeDriver(ChromeProfile profile, ChromeExtension extension) {
        super((CommandExecutor)new ChromeCommandExecutor(new ChromeBinary(profile, extension)), (Capabilities)DesiredCapabilities.chrome());
        this.setElementConverter(new JsonToWebElementConverter(this){

            protected RemoteWebElement newRemoteWebElement() {
                return new ChromeWebElement(ChromeDriver.this);
            }
        });
    }

    public ChromeDriver() {
        this(new ChromeProfile(), new ChromeExtension());
    }

    protected void startClient() {
        ((ChromeCommandExecutor)this.getCommandExecutor()).start();
    }

    protected void stopClient() {
        ((ChromeCommandExecutor)this.getCommandExecutor()).stop();
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        try {
            return super.execute(driverCommand, parameters);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof FatalChromeException) {
                this.stopClient();
                this.startClient();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WebDriverException((Throwable)e);
        }
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css", using);
    }

    protected RemoteWebElement newRemoteWebElement() {
        ChromeWebElement element = new ChromeWebElement(this);
        return element;
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        return (X)target.convertFromBase64Png(this.execute("screenshot", (Map<String, ?>)ImmutableMap.of()).getValue().toString());
    }
}

