/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.protocol.transaction;

import info.aduna.xml.XMLUtil;
import info.aduna.xml.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.DatatypeConverter;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SPARQLUpdateOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.StatementOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;

public class TransactionWriter {
    public void serialize(Iterable<? extends TransactionOperation> txn, OutputStream out) throws IOException {
        assert (txn != null) : "operation list must not be null";
        assert (out != null) : "output stream must not be null";
        XMLWriter xmlWriter = new XMLWriter(out);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.startTag("transaction");
        for (TransactionOperation transactionOperation : txn) {
            this.serialize(transactionOperation, xmlWriter);
        }
        xmlWriter.endTag("transaction");
        xmlWriter.endDocument();
    }

    private void serialize(TransactionOperation op, XMLWriter xmlWriter) throws IOException {
        if (op instanceof AddStatementOperation) {
            this.serialize((AddStatementOperation)op, xmlWriter);
        } else if (op instanceof RemoveStatementsOperation) {
            this.serialize((RemoveStatementsOperation)op, xmlWriter);
        } else if (op instanceof ClearOperation) {
            this.serialize((ClearOperation)op, xmlWriter);
        } else if (op instanceof SetNamespaceOperation) {
            this.serialize((SetNamespaceOperation)op, xmlWriter);
        } else if (op instanceof RemoveNamespaceOperation) {
            this.serialize((RemoveNamespaceOperation)op, xmlWriter);
        } else if (op instanceof ClearNamespacesOperation) {
            this.serialize((ClearNamespacesOperation)op, xmlWriter);
        } else if (op instanceof SPARQLUpdateOperation) {
            this.serialize((SPARQLUpdateOperation)op, xmlWriter);
        } else if (op != null) {
            throw new IllegalArgumentException("Unknown operation type: " + op.getClass());
        }
    }

    private void serialize(AddStatementOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("add");
        this.serialize((StatementOperation)op, xmlWriter);
        xmlWriter.endTag("add");
    }

    private void serialize(SPARQLUpdateOperation op, XMLWriter xmlWriter) throws IOException {
        String baseURI = op.getBaseURI();
        if (baseURI != null) {
            xmlWriter.setAttribute("baseURI", baseURI);
        }
        xmlWriter.setAttribute("includeInferred", op.isIncludeInferred());
        xmlWriter.startTag("sparql");
        String updateString = op.getUpdateString();
        xmlWriter.textElement("updateString", updateString);
        Dataset dataset = op.getDataset();
        if (dataset != null) {
            xmlWriter.startTag("dataset");
            xmlWriter.startTag("defaultGraphs");
            for (URI defaultGraph : dataset.getDefaultGraphs()) {
                xmlWriter.textElement("graph", defaultGraph.stringValue());
            }
            xmlWriter.endTag("defaultGraphs");
            xmlWriter.startTag("namedGraphs");
            for (URI namedGraph : dataset.getNamedGraphs()) {
                xmlWriter.textElement("graph", namedGraph.stringValue());
            }
            xmlWriter.endTag("namedGraphs");
            xmlWriter.startTag("defaultRemoveGraphs");
            for (URI defaultRemoveGraph : dataset.getDefaultRemoveGraphs()) {
                xmlWriter.textElement("graph", defaultRemoveGraph.stringValue());
            }
            xmlWriter.endTag("defaultRemoveGraphs");
            if (dataset.getDefaultInsertGraph() != null) {
                xmlWriter.textElement("defaultInsertGraph", dataset.getDefaultInsertGraph().stringValue());
            }
            xmlWriter.endTag("dataset");
        }
        xmlWriter.endTag("sparql");
    }

    private void serialize(RemoveStatementsOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("remove");
        this.serialize((StatementOperation)op, xmlWriter);
        xmlWriter.endTag("remove");
    }

    private void serialize(StatementOperation op, XMLWriter xmlWriter) throws IOException {
        this.serialize(op.getSubject(), xmlWriter);
        this.serialize(op.getPredicate(), xmlWriter);
        this.serialize(op.getObject(), xmlWriter);
        this.serialize(op.getContexts(), xmlWriter);
    }

    private void serialize(ClearOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("clear");
        this.serialize(op.getContexts(), xmlWriter);
        xmlWriter.endTag("clear");
    }

    private void serialize(SetNamespaceOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.setAttribute("prefix", op.getPrefix());
        xmlWriter.setAttribute("name", op.getName());
        xmlWriter.emptyElement("setNamespace");
    }

    private void serialize(RemoveNamespaceOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.setAttribute("prefix", op.getPrefix());
        xmlWriter.emptyElement("removeNamespace");
    }

    private void serialize(ClearNamespacesOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.emptyElement("clearNamespaces");
    }

    private void serialize(Resource[] contexts, XMLWriter xmlWriter) throws IOException {
        if (contexts.length > 0) {
            xmlWriter.startTag("contexts");
            for (Resource context : contexts) {
                this.serialize(context, xmlWriter);
            }
            xmlWriter.endTag("contexts");
        } else {
            xmlWriter.emptyElement("contexts");
        }
    }

    private void serialize(Value value, XMLWriter xmlWriter) throws IOException {
        if (value instanceof Resource) {
            this.serialize((Resource)value, xmlWriter);
        } else if (value instanceof Literal) {
            this.serialize((Literal)value, xmlWriter);
        } else if (value == null) {
            this.serializeNull(xmlWriter);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass().toString());
        }
    }

    private void serialize(Resource resource, XMLWriter xmlWriter) throws IOException {
        if (resource instanceof URI) {
            this.serialize((URI)resource, xmlWriter);
        } else if (resource instanceof BNode) {
            this.serialize((BNode)resource, xmlWriter);
        } else if (resource == null) {
            this.serializeNull(xmlWriter);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + resource.getClass().toString());
        }
    }

    private void serialize(URI uri, XMLWriter xmlWriter) throws IOException {
        if (uri != null) {
            xmlWriter.textElement("uri", uri.toString());
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    private void serialize(BNode bnode, XMLWriter xmlWriter) throws IOException {
        if (bnode != null) {
            xmlWriter.textElement("bnode", bnode.getID());
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    private void serialize(Literal literal, XMLWriter xmlWriter) throws IOException {
        if (literal != null) {
            if (literal.getLanguage() != null) {
                xmlWriter.setAttribute("xml:lang", literal.getLanguage());
            }
            if (literal.getDatatype() != null) {
                xmlWriter.setAttribute("datatype", literal.getDatatype().toString());
            }
            String label = literal.getLabel();
            boolean valid = true;
            int i = 0;
            while (valid && i < label.length()) {
                char c = label.charAt(i++);
                valid = XMLUtil.isValidCharacterDataChar((char)c);
            }
            if (!valid) {
                xmlWriter.setAttribute("encoding", "base64");
                label = DatatypeConverter.printBase64Binary((byte[])label.getBytes("UTF-8"));
            }
            xmlWriter.textElement("literal", label);
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    private void serializeNull(XMLWriter xmlWriter) throws IOException {
        xmlWriter.emptyElement("null");
    }
}

