/*
 * Decompiled with CFR 0.152.
 */
package ninja.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ninja.validation.ConstraintViolation;
import ninja.validation.FieldViolation;
import ninja.validation.Validation;

public class ValidationImpl
implements Validation {
    private final Map<String, List<FieldViolation>> fieldViolations = Maps.newHashMap();
    private final List<ConstraintViolation> generalViolations = Lists.newArrayList();
    private final Map<String, List<FieldViolation>> beanViolations = Maps.newHashMap();

    @Override
    public boolean hasViolations() {
        return !this.fieldViolations.isEmpty() || !this.generalViolations.isEmpty() || !this.beanViolations.isEmpty();
    }

    @Override
    public void addFieldViolation(FieldViolation fieldViolation) {
        if (fieldViolation.field == null) {
            this.generalViolations.add(fieldViolation.constraintViolation);
        } else {
            if (!this.fieldViolations.containsKey(fieldViolation.field)) {
                this.fieldViolations.put(fieldViolation.field, Lists.newArrayList());
            }
            this.fieldViolations.get(fieldViolation.field).add(fieldViolation);
        }
    }

    @Override
    public void addFieldViolation(String field, ConstraintViolation constraintViolation) {
        this.addFieldViolation(new FieldViolation(field, constraintViolation));
    }

    @Override
    public boolean hasFieldViolation(String field) {
        return this.fieldViolations.containsKey(field);
    }

    @Override
    public List<FieldViolation> getFieldViolations() {
        ArrayList sumViolations = Lists.newArrayList();
        for (List<FieldViolation> fieldViolation : this.fieldViolations.values()) {
            sumViolations.addAll(fieldViolation);
        }
        return sumViolations;
    }

    @Override
    public List<FieldViolation> getFieldViolations(String field) {
        return this.fieldViolations.get(field);
    }

    @Override
    public void addBeanViolation(FieldViolation fieldViolation) {
        if (!this.beanViolations.containsKey(fieldViolation.field)) {
            this.beanViolations.put(fieldViolation.field, Lists.newArrayList());
        }
        this.beanViolations.get(fieldViolation.field).add(fieldViolation);
    }

    @Override
    public boolean hasBeanViolation(String field) {
        return this.beanViolations.containsKey(field);
    }

    @Override
    public boolean hasBeanViolations() {
        return !this.beanViolations.isEmpty();
    }

    @Override
    public List<FieldViolation> getBeanViolations() {
        ArrayList sumViolations = Lists.newArrayList();
        for (List<FieldViolation> fieldViolation : this.beanViolations.values()) {
            sumViolations.addAll(fieldViolation);
        }
        return sumViolations;
    }

    @Override
    public List<FieldViolation> getBeanViolations(String field) {
        return this.beanViolations.get(field);
    }

    @Override
    public void addViolation(ConstraintViolation constraintViolation) {
        this.generalViolations.add(constraintViolation);
    }

    @Override
    public List<ConstraintViolation> getGeneralViolations() {
        return this.generalViolations;
    }
}

