/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.CaseFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwissKnife {
    private static final Logger logger = LoggerFactory.getLogger(SwissKnife.class);

    public static PropertiesConfiguration loadConfigurationInUtf8(String fileOrUrlOrClasspathUrl) {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.setEncoding("utf-8");
        propertiesConfiguration.setDelimiterParsingDisabled(true);
        propertiesConfiguration.setFileName(fileOrUrlOrClasspathUrl);
        propertiesConfiguration.getLayout().setSingleLine("application.secret", true);
        try {
            propertiesConfiguration.load(fileOrUrlOrClasspathUrl);
        }
        catch (ConfigurationException e) {
            logger.info("Could not load file " + fileOrUrlOrClasspathUrl + " (not a bad thing necessarily, but I am returing null)");
            return null;
        }
        return propertiesConfiguration;
    }

    public static String getRealClassNameLowerCamelCase(Object object) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, object.getClass().getSimpleName());
    }
}

