/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import ninja.utils.SecretGenerator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaPropertiesImplTool {
    private static final Logger logger = LoggerFactory.getLogger(NinjaPropertiesImplTool.class);

    public static void checkThatApplicationSecretIsSet(boolean isProd, String baseDirWithoutTrailingSlash, PropertiesConfiguration defaultConfiguration, Configuration compositeConfiguration) {
        String applicationSecret = compositeConfiguration.getString("application.secret");
        if (applicationSecret == null || applicationSecret.isEmpty()) {
            if (isProd) {
                String errorMessage = "Fatal error. Key application.secret not set. Please fix that.";
                logger.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            logger.info("Key application.secret not set. Generating new one and setting in conf/application.conf.");
            String secret = SecretGenerator.generateSecret();
            compositeConfiguration.setProperty("application.secret", (Object)secret);
            defaultConfiguration.setProperty("application.secret", (Object)secret);
            try {
                String pathToApplicationConfInSrcDir = baseDirWithoutTrailingSlash + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + "conf/application.conf";
                Files.createParentDirs((File)new File(pathToApplicationConfInSrcDir));
                defaultConfiguration.save(pathToApplicationConfInSrcDir);
                defaultConfiguration.save();
            }
            catch (ConfigurationException e) {
                logger.error("Error while saving new secret to application.conf.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error while saving new secret to application.conf.", (Throwable)e);
            }
        }
    }
}

