/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.io.File;
import java.util.Properties;
import ninja.utils.NinjaMode;
import ninja.utils.NinjaProperties;
import ninja.utils.NinjaPropertiesImplTool;
import ninja.utils.SwissKnife;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NinjaPropertiesImpl
implements NinjaProperties {
    private static final Logger logger = LoggerFactory.getLogger(NinjaPropertiesImpl.class);
    private final NinjaMode ninjaMode;
    private String contextPath = "";
    private final String ERROR_KEY_NOT_FOUND = "Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work";
    private CompositeConfiguration compositeConfiguration;

    public NinjaPropertiesImpl(NinjaMode ninjaMode) {
        this(ninjaMode, null);
    }

    public NinjaPropertiesImpl(NinjaMode ninjaMode, String externalConfigurationPath) {
        this.ninjaMode = ninjaMode;
        this.compositeConfiguration = new CompositeConfiguration();
        PropertiesConfiguration defaultConfiguration = null;
        Configuration prefixedDefaultConfiguration = null;
        PropertiesConfiguration externalConfiguration = null;
        Configuration prefixedExternalConfiguration = null;
        defaultConfiguration = SwissKnife.loadConfigurationInUtf8("conf/application.conf");
        if (defaultConfiguration != null) {
            prefixedDefaultConfiguration = defaultConfiguration.subset("%" + ninjaMode.name());
            if (NinjaMode.dev == ninjaMode) {
                defaultConfiguration.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            }
        } else {
            String errorMessage = String.format("Error reading configuration file. Make sure you got a default config file %s", "conf/application.conf");
            logger.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        String ninjaExternalConf = externalConfigurationPath;
        if (ninjaExternalConf == null) {
            ninjaExternalConf = System.getProperty("ninja.external.configuration");
        }
        if (ninjaExternalConf != null) {
            externalConfiguration = SwissKnife.loadConfigurationInUtf8(ninjaExternalConf);
            if (externalConfiguration == null) {
                String errorMessage = String.format("Ninja was told to use an external configuration%n %s = %s %n.But the corresponding file cannot be found.%n Make sure it is visible to this application and on the classpath.", "ninja.external.configuration", ninjaExternalConf);
                logger.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            boolean shouldReload = Boolean.getBoolean("ninja.external.reload");
            if (shouldReload) {
                externalConfiguration.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            }
            prefixedExternalConfiguration = externalConfiguration.subset("%" + ninjaMode.name());
        }
        if (prefixedExternalConfiguration != null) {
            this.compositeConfiguration.addConfiguration(prefixedExternalConfiguration);
        }
        if (externalConfiguration != null) {
            this.compositeConfiguration.addConfiguration((Configuration)externalConfiguration);
        }
        if (prefixedDefaultConfiguration != null) {
            this.compositeConfiguration.addConfiguration(prefixedDefaultConfiguration);
        }
        if (defaultConfiguration != null) {
            this.compositeConfiguration.addConfiguration((Configuration)defaultConfiguration);
        }
        NinjaPropertiesImplTool.checkThatApplicationSecretIsSet(this.isProd(), new File("").getAbsolutePath(), defaultConfiguration, (Configuration)this.compositeConfiguration);
    }

    @Override
    public String get(String key) {
        String value;
        try {
            value = this.compositeConfiguration.getString(key);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    @Override
    public String getOrDie(String key) {
        String value = this.get(key);
        if (value == null) {
            logger.error(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
            throw new RuntimeException(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
        }
        return value;
    }

    @Override
    public Integer getInteger(String key) {
        Integer value;
        try {
            value = this.compositeConfiguration.getInt(key);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    @Override
    public Integer getIntegerOrDie(String key) {
        Integer value = this.getInteger(key);
        if (value == null) {
            logger.error(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
            throw new RuntimeException(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
        }
        return value;
    }

    @Override
    public Boolean getBooleanOrDie(String key) {
        Boolean value = this.getBoolean(key);
        if (value == null) {
            logger.error(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
            throw new RuntimeException(String.format("Key %s does not exist. Please include it in your application.conf. Otherwise this app will not work", key));
        }
        return value;
    }

    @Override
    public Boolean getBoolean(String key) {
        Boolean value;
        try {
            value = this.compositeConfiguration.getBoolean(key);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    public void setProperty(String key, String value) {
        this.compositeConfiguration.setProperty(key, (Object)value);
    }

    public void bindProperties(Binder binder) {
        Names.bindProperties((Binder)binder, (Properties)ConfigurationConverter.getProperties((Configuration)this.compositeConfiguration));
    }

    @Override
    public boolean isProd() {
        return this.ninjaMode.equals((Object)NinjaMode.prod);
    }

    @Override
    public boolean isDev() {
        return this.ninjaMode.equals((Object)NinjaMode.dev);
    }

    @Override
    public boolean isTest() {
        return this.ninjaMode.equals((Object)NinjaMode.test);
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public Properties getAllCurrentNinjaProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.compositeConfiguration);
    }

    @Override
    public String[] getStringArray(String key) {
        String value = this.compositeConfiguration.getString(key);
        if (value != null) {
            return (String[])Iterables.toArray((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)value), String.class);
        }
        return null;
    }

    @Override
    public String getWithDefault(String key, String defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Integer getIntegerWithDefault(String key, Integer defaultValue) {
        Integer value = this.getInteger(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Boolean getBooleanWithDefault(String key, Boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

