/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import java.lang.reflect.Method;
import java.util.Objects;

public class MethodReference {
    private final Class declaringClass;
    private final String methodName;

    public MethodReference(Class declaringClass, String methodName) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
    }

    public MethodReference(Method method) {
        this(method.getDeclaringClass(), method.getName());
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.declaringClass);
        hash = 83 * hash + Objects.hashCode(this.methodName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodReference other = (MethodReference)obj;
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        return Objects.equals(this.declaringClass, other.declaringClass);
    }
}

