/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Injector;
import java.util.concurrent.atomic.AtomicReference;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;

public class ImplFromPropertiesFactory<T> {
    private final Injector injector;
    private final NinjaProperties ninjaProperties;
    private final String propertyName;
    private final Class<? extends T> targetClass;
    private final String defaultClassName;
    private final Logger logger;
    private final AtomicReference<Class<? extends T>> implementationClassRef;

    public ImplFromPropertiesFactory(Injector injector, NinjaProperties ninjaProperties, String propertyName, Class<? extends T> targetClass, String defaultClassName, boolean deferResolveUntilGet, Logger logger) {
        this.injector = injector;
        this.ninjaProperties = ninjaProperties;
        this.propertyName = propertyName;
        this.targetClass = targetClass;
        this.defaultClassName = defaultClassName;
        this.logger = logger;
        this.implementationClassRef = new AtomicReference();
        if (!deferResolveUntilGet) {
            this.implementationClassRef.set(this.resolveImplementationClass());
        }
    }

    public T create() {
        return (T)this.injector.getInstance(this.getImplementationClass());
    }

    public Class<? extends T> getImplementationClass() {
        Class<? extends T> implementationClass = this.implementationClassRef.get();
        if (implementationClass != null) {
            return implementationClass;
        }
        this.implementationClassRef.compareAndSet(null, this.resolveImplementationClass());
        return this.implementationClassRef.get();
    }

    private Class<? extends T> resolveImplementationClass() {
        String implementationClassName = this.ninjaProperties.get(this.propertyName);
        Class<? extends T> implementationClass = null;
        if (implementationClassName != null) {
            implementationClass = this.resolveClass(implementationClassName, this.targetClass, this.propertyName, true);
            this.logger.info("Using {} as implementation for {}", (Object)implementationClassName, (Object)this.targetClass.getCanonicalName());
        } else if (this.defaultClassName != null) {
            implementationClass = this.resolveClass(this.defaultClassName, this.targetClass, this.propertyName, false);
            this.logger.info("Using {} as default implementation for {}", (Object)this.defaultClassName, (Object)this.targetClass.getCanonicalName());
        }
        return implementationClass;
    }

    private Class<? extends T> resolveClass(String className, Class<? extends T> targetClass, String propertyName, boolean viaConfiguration) {
        String message = viaConfiguration ? "in configuration " + propertyName : "as default for configuration " + propertyName;
        try {
            Class<?> resolvedClass = Class.forName(className);
            return resolvedClass.asSubclass(targetClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class defined " + message + " not found (" + className + ")", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Class defined " + message + " is not an instance of (" + targetClass + ")", e);
        }
    }
}

