/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

public class CookieDataCodec {
    public static void decode(Map<String, String> map, String data) throws UnsupportedEncodingException {
        String[] keyValues;
        for (String keyValue : keyValues = data.split("&")) {
            String[] splitted = keyValue.split("=", 2);
            if (splitted.length != 2) continue;
            map.put(URLDecoder.decode(splitted[0], "utf-8"), URLDecoder.decode(splitted[1], "utf-8"));
        }
    }

    public static String encode(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder data = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            data.append(separator).append(URLEncoder.encode(entry.getKey(), "utf-8")).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8"));
            separator = "&";
        }
        return data.toString();
    }

    public static boolean safeEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        int equal = 0;
        for (int i = 0; i < a.length(); ++i) {
            equal = (char)(equal | a.charAt(i) ^ b.charAt(i));
        }
        return equal == 0;
    }
}

