/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Writer;
import ninja.Context;
import ninja.Result;
import ninja.template.TemplateEngine;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemplateEngineText
implements TemplateEngine {
    private final Logger logger = LoggerFactory.getLogger(TemplateEngineText.class);

    @Inject
    public TemplateEngineText() {
    }

    @Override
    public void invoke(Context context, Result result) {
        ResponseStreams responseStreams = context.finalizeHeaders(result);
        try (Writer outputWriter = responseStreams.getWriter();){
            outputWriter.write(result.getRenderable().toString());
        }
        catch (IOException e) {
            this.logger.error("Error while rendering plain text", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getSuffixOfTemplatingEngine() {
        return null;
    }
}

