/*
 * Decompiled with CFR 0.152.
 */
package ninja.standalone;

import com.google.common.base.Optional;
import com.google.inject.CreationException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import ninja.standalone.Standalone;
import ninja.standalone.StandaloneHelper;
import ninja.utils.NinjaMode;
import ninja.utils.NinjaModeHelper;
import ninja.utils.NinjaPropertiesImpl;
import ninja.utils.OverlayedNinjaProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStandalone<T extends AbstractStandalone>
implements Standalone<T>,
Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected NinjaMode ninjaMode = NinjaModeHelper.determineModeFromSystemPropertiesOrProdIfNotSet();
    protected String externalConfigurationPath;
    protected String name;
    protected String host;
    protected Integer port;
    protected String contextPath;
    protected Long idleTimeout;
    protected Integer sslPort;
    protected URI sslKeystoreUri;
    protected String sslKeystorePassword;
    protected URI sslTruststoreUri;
    protected String sslTruststorePassword;
    protected boolean configured;
    protected boolean started;
    protected NinjaPropertiesImpl ninjaProperties;
    protected OverlayedNinjaProperties overlayedNinjaProperties;
    protected List<String> serverUrls;
    protected List<String> baseUrls;

    public AbstractStandalone(String name) {
        this.name = name;
        this.configured = false;
        this.started = false;
    }

    @Override
    public final void run() {
        Thread.currentThread().setName(this.name);
        try {
            this.configure();
        }
        catch (Exception e) {
            this.logger.error("Unable to configure {}", (Object)this.name, (Object)e);
            System.exit(1);
        }
        try {
            this.start();
        }
        catch (Exception e) {
            this.logger.error("Unable to start {}", (Object)this.name, (Object)e);
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractStandalone.this.shutdown();
            }
        });
        try {
            this.join();
        }
        catch (Exception e) {
            this.logger.warn("Interrupted (most likely JVM is shutting down and this is safe to ignore)");
        }
    }

    @Override
    public final T configure() throws Exception {
        this.checkNotConfigured();
        this.ninjaProperties = new NinjaPropertiesImpl(this.ninjaMode, this.externalConfigurationPath);
        this.overlayedNinjaProperties = new OverlayedNinjaProperties(this.ninjaProperties);
        this.host(this.overlayedNinjaProperties.get("ninja.host", this.host, DEFAULT_HOST));
        this.port(this.overlayedNinjaProperties.getInteger("ninja.port", this.port, DEFAULT_PORT));
        this.contextPath(this.overlayedNinjaProperties.get("ninja.context", this.contextPath, ""));
        this.idleTimeout(this.overlayedNinjaProperties.getLong("ninja.idle.timeout", this.idleTimeout, DEFAULT_IDLE_TIMEOUT));
        this.sslPort(this.overlayedNinjaProperties.getInteger("ninja.ssl.port", this.sslPort, DEFAULT_SSL_PORT));
        this.sslKeystoreUri(this.overlayedNinjaProperties.getURI("ninja.ssl.keystore.uri", this.sslKeystoreUri, this.ninjaMode == NinjaMode.prod ? null : new URI("classpath:/ninja/standalone/ninja-development.keystore")));
        this.sslKeystorePassword(this.overlayedNinjaProperties.get("ninja.ssl.keystore.password", this.sslKeystorePassword, this.ninjaMode == NinjaMode.prod ? null : "password"));
        this.sslTruststoreUri(this.overlayedNinjaProperties.getURI("ninja.ssl.truststore.uri", this.sslTruststoreUri, this.ninjaMode == NinjaMode.prod ? null : new URI("classpath:/ninja/standalone/ninja-development.truststore")));
        this.sslTruststorePassword(this.overlayedNinjaProperties.get("ninja.ssl.truststore.password", this.sslTruststorePassword, this.ninjaMode == NinjaMode.prod ? null : "password"));
        if (this.getPort() == null || this.getPort() == 0) {
            this.port(StandaloneHelper.findAvailablePort(8000, 9000));
        }
        if (this.getSslPort() == null || this.getSslPort() == 0) {
            this.sslPort(StandaloneHelper.findAvailablePort(9001, 9999));
        }
        this.doConfigure();
        this.configured = true;
        this.serverUrls = this.createServerUrls();
        this.baseUrls = this.createBaseUrls();
        if (this.serverUrls == null || this.serverUrls.isEmpty()) {
            throw new IllegalStateException("All server ports were disabled. Check the 'ninja.port' property and possibly others depending your standalone.");
        }
        String serverName = this.ninjaProperties.get("application.server.name");
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            this.ninjaProperties.setProperty("application.server.name", this.getServerUrls().get(0));
        }
        return (T)this;
    }

    @Override
    public final T start() throws Exception {
        if (!this.configured) {
            this.configure();
        }
        this.doStart();
        this.started = true;
        this.logBaseUrls();
        return (T)this;
    }

    @Override
    public final T join() throws Exception {
        this.checkStarted();
        this.doJoin();
        return (T)this;
    }

    @Override
    public final T shutdown() {
        this.doShutdown();
        return (T)this;
    }

    protected abstract void doConfigure() throws Exception;

    protected abstract void doStart() throws Exception;

    protected abstract void doJoin() throws Exception;

    protected abstract void doShutdown();

    protected void checkNotConfigured() {
        if (this.configured) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + ".configure() already called");
        }
    }

    protected void checkConfigured() {
        if (!this.configured) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + ".configure() not called yet");
        }
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + ".start() not called yet");
        }
    }

    @Override
    public NinjaMode getNinjaMode() {
        return this.ninjaMode;
    }

    @Override
    public T ninjaMode(NinjaMode ninjaMode) {
        this.ninjaMode = ninjaMode;
        return (T)this;
    }

    @Override
    public String getExternalConfigurationPath() {
        return this.externalConfigurationPath;
    }

    @Override
    public T externalConfigurationPath(String externalConfigurationPath) {
        this.externalConfigurationPath = externalConfigurationPath;
        return (T)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public T port(int port) {
        this.port = port;
        return (T)this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public T host(String host) {
        this.host = host;
        return (T)this;
    }

    @Override
    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public T idleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (T)this;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public T contextPath(String contextPath) {
        StandaloneHelper.checkContextPath(contextPath);
        this.contextPath = contextPath;
        return (T)this;
    }

    @Override
    public Integer getSslPort() {
        return this.sslPort;
    }

    @Override
    public T sslPort(int sslPort) {
        this.sslPort = sslPort;
        return (T)this;
    }

    @Override
    public URI getSslKeystoreUri() {
        return this.sslKeystoreUri;
    }

    @Override
    public T sslKeystoreUri(URI keystoreUri) {
        this.sslKeystoreUri = keystoreUri;
        return (T)this;
    }

    @Override
    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public T sslKeystorePassword(String keystorePassword) {
        this.sslKeystorePassword = keystorePassword;
        return (T)this;
    }

    @Override
    public URI getSslTruststoreUri() {
        return this.sslTruststoreUri;
    }

    @Override
    public T sslTruststoreUri(URI truststoreUri) {
        this.sslTruststoreUri = truststoreUri;
        return (T)this;
    }

    @Override
    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    @Override
    public T sslTruststorePassword(String truststorePassword) {
        this.sslTruststorePassword = truststorePassword;
        return (T)this;
    }

    @Override
    public NinjaPropertiesImpl getNinjaProperties() {
        this.checkConfigured();
        return this.ninjaProperties;
    }

    @Override
    public List<String> getServerUrls() {
        this.checkConfigured();
        return this.serverUrls;
    }

    @Override
    public List<String> getBaseUrls() {
        this.checkConfigured();
        return this.baseUrls;
    }

    @Override
    public boolean isPortEnabled() {
        return this.port != null && this.port > -1;
    }

    @Override
    public boolean isSslPortEnabled() {
        return this.sslPort != null && this.sslPort > -1;
    }

    protected List<String> createServerUrls() {
        this.checkConfigured();
        ArrayList<String> urls = new ArrayList<String>();
        if (this.isPortEnabled()) {
            urls.add(this.createServerUrl("http", this.getHost(), this.getPort()));
        }
        if (this.isSslPortEnabled()) {
            urls.add(this.createServerUrl("https", this.getHost(), this.getSslPort()));
        }
        return urls;
    }

    protected List<String> createBaseUrls() {
        this.checkConfigured();
        ArrayList<String> urls = new ArrayList<String>();
        if (this.isPortEnabled()) {
            urls.add(this.createBaseUrl("http", this.getHost(), this.getPort(), this.getContextPath()));
        }
        if (this.isSslPortEnabled()) {
            urls.add(this.createBaseUrl("https", this.getHost(), this.getSslPort(), this.getContextPath()));
        }
        return urls;
    }

    protected String createServerUrl(String scheme, String host, Integer port) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(host != null ? host : "localhost");
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        return sb.toString();
    }

    protected String createBaseUrl(String scheme, String host, Integer port, String context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createServerUrl(scheme, host, port));
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            sb.append(context);
        }
        return sb.toString();
    }

    protected Exception tryToUnwrapInjectorException(Exception exception) {
        Throwable cause = exception.getCause();
        if (cause != null && cause instanceof CreationException) {
            return (CreationException)cause;
        }
        return exception;
    }

    protected String getLoggableIdentifier() {
        StringBuilder ports = new StringBuilder();
        if (this.isPortEnabled()) {
            ports.append(this.getPort());
        }
        if (this.isSslPortEnabled()) {
            if (ports.length() > 0) {
                ports.append(", ");
            }
            ports.append(this.getSslPort());
            ports.append("/ssl");
        }
        StringBuilder s = new StringBuilder();
        s.append("on ");
        s.append((String)Optional.fromNullable((Object)this.getHost()).or((Object)"<all>"));
        s.append(":");
        s.append((CharSequence)ports);
        return s.toString();
    }

    protected void logBaseUrls() {
        this.logger.info("-------------------------------------------------------");
        this.logger.info("Ninja application running at");
        List<String> uris = this.getBaseUrls();
        for (String uri : uris) {
            this.logger.info(" => {}", (Object)uri);
        }
        this.logger.info("-------------------------------------------------------");
    }

    protected SSLContext createSSLContext() throws Exception {
        if (this.sslKeystoreUri == null) {
            throw new IllegalStateException("Unable to create SSL context. Configuration key ninja.ssl.keystore.uri has empty value.  Please check your configuration file.");
        }
        if (this.sslKeystorePassword == null) {
            throw new IllegalStateException("Unable to create SSL context. Configuration key ninja.ssl.keystore.password has empty value.  Please check your configuration file.");
        }
        if (this.sslTruststoreUri == null) {
            throw new IllegalStateException("Unable to create SSL context. Configuration key ninja.ssl.truststore.uri has empty value.  Please check your configuration file.");
        }
        if (this.sslTruststorePassword == null) {
            throw new IllegalStateException("Unable to create SSL context. Configuration key ninja.ssl.truststore.password has empty value.  Please check your configuration file.");
        }
        return StandaloneHelper.createSSLContext(this.sslKeystoreUri, this.sslKeystorePassword.toCharArray(), this.sslTruststoreUri, this.sslTruststorePassword.toCharArray());
    }
}

