/*
 * Decompiled with CFR 0.152.
 */
package ninja.migrations.flyway;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import ninja.migrations.MigrationEngine;
import ninja.utils.NinjaProperties;
import org.flywaydb.core.Flyway;

@Singleton
public class MigrationEngineFlyway
implements MigrationEngine {
    private final NinjaProperties ninjaProperties;

    @Inject
    public MigrationEngineFlyway(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    @Override
    public void migrate() {
        String connectionUrl = this.ninjaProperties.getOrDie("db.connection.url");
        String connectionUsername = this.ninjaProperties.getOrDie("db.connection.username");
        String connectionPassword = this.ninjaProperties.getOrDie("db.connection.password");
        Flyway flyway = new Flyway();
        flyway.setDataSource(connectionUrl, connectionUsername, connectionPassword, new String[0]);
        if (this.ninjaProperties.getBooleanWithDefault("ninja.migration.drop", this.ninjaProperties.isTest()).booleanValue()) {
            flyway.clean();
        }
        flyway.migrate();
    }
}

