/*
 * Decompiled with CFR 0.152.
 */
package ninja.lifecycle;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import ninja.lifecycle.Dispose;
import ninja.lifecycle.LifecycleRegister;
import ninja.lifecycle.Start;
import ninja.lifecycle.Target;

public class LifecycleSupport {
    private final LifecycleRegister lifecycleRegister = new LifecycleRegister();

    public static Module getModule() {
        return new LifecycleSupport().constructModule();
    }

    private LifecycleSupport() {
    }

    public boolean hasLifecycleMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(Start.class) == null && method.getAnnotation(Dispose.class) == null) continue;
            return true;
        }
        return false;
    }

    public void registerLifecycle(Object target) {
        for (Method method : target.getClass().getMethods()) {
            Dispose dispose;
            Start start = method.getAnnotation(Start.class);
            if (start != null) {
                this.lifecycleRegister.registerStartable(new Target(method, target, start.order()));
            }
            if ((dispose = method.getAnnotation(Dispose.class)) == null) continue;
            this.lifecycleRegister.registerDisposable(new Target(method, target, dispose.order()));
        }
    }

    private Module constructModule() {
        return new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), new LifecycleAnnotatedListener());
                this.bind(LifecycleRegister.class).toInstance((Object)LifecycleSupport.this.lifecycleRegister);
                this.bind(LifecycleSupport.class).toInstance((Object)LifecycleSupport.this);
            }
        };
    }

    private class LifecycleListener<I>
    implements InjectionListener<I> {
        private LifecycleListener() {
        }

        public void afterInjection(I injectee) {
            LifecycleSupport.this.registerLifecycle(injectee);
        }
    }

    private class LifecycleAnnotatedListener
    implements TypeListener {
        private LifecycleAnnotatedListener() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            if (LifecycleSupport.this.hasLifecycleMethod(type.getRawType())) {
                encounter.register(new LifecycleListener());
            }
        }
    }
}

