/*
 * Decompiled with CFR 0.152.
 */
package ninja.lifecycle;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ninja.lifecycle.FailedDisposeException;
import ninja.lifecycle.FailedStartException;
import ninja.lifecycle.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class LifecycleRegister {
    private static final Logger log = LoggerFactory.getLogger(LifecycleRegister.class);
    private final List<Target> startables = Collections.synchronizedList(new ArrayList());
    private final List<Target> disposables = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean started = new AtomicBoolean(false);

    LifecycleRegister() {
    }

    public void start() {
        if (this.started.get()) {
            throw new FailedStartException("Ninja service is already started!");
        }
        ArrayList<Target> toStart = new ArrayList<Target>(this.startables);
        this.started.set(true);
        this.startables.clear();
        Collections.sort(toStart);
        for (Target target : toStart) {
            this.invokeTarget(target);
        }
    }

    public void stop() {
        if (!this.started.get()) {
            throw new FailedDisposeException("Ninja service is not started!");
        }
        ArrayList<Target> toDispose = new ArrayList<Target>(this.disposables);
        this.started.set(false);
        this.disposables.clear();
        Collections.sort(toDispose);
        for (Target target : Lists.reverse(toDispose)) {
            try {
                this.invokeTarget(target);
            }
            catch (Exception e) {
                log.warn("Error stopping service", (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void registerStartable(Target target) {
        if (this.started.get()) {
            log.warn("Startable instantiated after the application has been started: " + target.getTarget().toString());
            this.invokeTarget(target);
        } else {
            this.startables.add(target);
        }
    }

    public void registerDisposable(Target target) {
        this.disposables.add(target);
    }

    public void invokeTarget(Target target) {
        try {
            target.getStartMethod().invoke(target.getTarget(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new FailedStartException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof FailedStartException) {
                throw (FailedStartException)e.getCause();
            }
            throw new FailedStartException(e.getCause());
        }
    }
}

