/*
 * Decompiled with CFR 0.152.
 */
package ninja.diagnostics;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.Route;
import ninja.diagnostics.DiagnosticError;
import ninja.exceptions.InternalServerErrorException;
import ninja.utils.ResponseStreams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticErrorRenderer {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticErrorRenderer.class);
    private final StringBuilder s = new StringBuilder();

    private DiagnosticErrorRenderer() {
    }

    public String render() {
        return this.s.toString();
    }

    public static void tryToRender(Context context, Result result, DiagnosticError diagnosticError, boolean throwInternalServerExceptionOnError) {
        try {
            DiagnosticErrorRenderer errorRenderer = DiagnosticErrorRenderer.build(context, result, diagnosticError);
            errorRenderer.renderResult(context, result);
        }
        catch (IOException e) {
            if (throwInternalServerExceptionOnError) {
                throw new InternalServerErrorException(e);
            }
            logger.error("Something is really fishy. Unable to render diagnostic error", (Throwable)e);
        }
    }

    public void renderResult(Context context, Result result) throws IOException {
        String out = this.render();
        result.contentType("text/html");
        result.charset("utf-8");
        ResponseStreams responseStreams = context.finalizeHeaders(result);
        try (Writer w = responseStreams.getWriter();){
            w.write(out);
            w.flush();
            w.close();
        }
    }

    public static DiagnosticErrorRenderer build(Context context, Result result, DiagnosticError diagnosticError) throws IOException {
        Result underlyingResult = diagnosticError.getUnderlyingResult();
        return new DiagnosticErrorRenderer().appendHeader(context, result, diagnosticError.getTitle()).appendTabsBegin(new String[]{"Exception", "Context", "Request", "Response"}).appendTabBegin(0).appendSourceSnippet(diagnosticError.getSourceLocation(), diagnosticError.getSourceLines(), diagnosticError.getLineNumberOfSourceLines(), diagnosticError.getLineNumberOfError()).appendThrowable(diagnosticError.getThrowable()).appendTabEnd().appendTabBegin(1).appendContext(context).appendTabEnd().appendTabBegin(2).appendRequest(context).appendTabEnd().appendTabBegin(3).appendResponse(underlyingResult).appendTabEnd().appendTabsEnd().appendFooter();
    }

    private DiagnosticErrorRenderer appendHeader(Context context, Result result, String title) throws IOException {
        String headerTemplate = this.getResource("diagnostic_header.html");
        String styleTemplate = this.getResource("diagnostic.css");
        headerTemplate = headerTemplate.replace("${TITLE}", this.escape(title));
        headerTemplate = headerTemplate.replace("${STYLE}", this.escape(styleTemplate));
        this.s.append(headerTemplate);
        if (result != null) {
            this.s.append("    <p id=\"detail\">\n");
            if (result.getStatusCode() != 200) {
                this.s.append("Status code ").append(result.getStatusCode());
            }
            this.s.append(" for request '").append(context.getMethod()).append(" ").append(context.getRequestPath()).append("'\n");
            if (context.getRoute() != null) {
                Route route = context.getRoute();
                this.s.append("<br />In controller method '").append(route.getControllerClass().getCanonicalName()).append(".").append(route.getControllerMethod().getName()).append("'\n");
            }
            this.s.append("    </p>\n");
        }
        return this;
    }

    private DiagnosticErrorRenderer appendTabsBegin(String[] names) throws IOException {
        this.s.append("<div class='tabs standard'>\n");
        this.s.append("    <ul class=\"tab-links\">\n");
        for (int i = 0; i < names.length; ++i) {
            this.s.append("        <li");
            if (i == 0) {
                this.s.append(" class=\"active\"");
            }
            this.s.append("><a href=\"#tab").append(i).append("\">").append(this.escape(names[i])).append("</a></li>\n");
        }
        this.s.append("    </ul>\n");
        this.s.append("    <div class=\"tab-content\">\n");
        return this;
    }

    private DiagnosticErrorRenderer appendTabsEnd() throws IOException {
        this.s.append("    </div>\n");
        this.s.append("</div>\n");
        return this;
    }

    private DiagnosticErrorRenderer appendTabBegin(int index) throws IOException {
        this.s.append("        <div id=\"tab").append(index).append("\" class=\"tab");
        if (index == 0) {
            this.s.append(" active");
        }
        this.s.append("\">\n");
        return this;
    }

    private DiagnosticErrorRenderer appendTabEnd() throws IOException {
        this.s.append("        </div>\n");
        return this;
    }

    private DiagnosticErrorRenderer appendFooter() throws IOException {
        this.s.append("<script type='text/javascript'>").append(this.getResource("jquery-1.11.1.min.js")).append("</script>");
        this.s.append("<script type='text/javascript'>").append(this.getResource("diagnostic.js")).append("</script>");
        this.s.append(this.getResource("diagnostic_footer.html"));
        return this;
    }

    private DiagnosticErrorRenderer appendContext(Context context) throws IOException {
        this.s.append("<div class=\"context\">\n");
        this.s.append("<h2>Route</h2>\n");
        if (context.getRoute() != null) {
            Iterator<Map.Entry<String, String>> route = context.getRoute();
            this.appendNameValue(this.s, "Http method", ((Route)((Object)route)).getHttpMethod());
            this.appendNameValue(this.s, "Controller method", ((Route)((Object)route)).getControllerClass().getCanonicalName() + "." + ((Route)((Object)route)).getControllerMethod().getName() + "()");
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> type : ((Route)((Object)route)).getControllerMethod().getParameterTypes()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(type.getCanonicalName());
            }
            this.appendNameValue(this.s, "Controller parameters", stringBuilder.toString());
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("<h2>Session</h2>\n");
        if (context.getSession() != null && !context.getSession().getData().isEmpty()) {
            for (Map.Entry entry : context.getSession().getData().entrySet()) {
                this.appendNameValue(this.s, (String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("<h2>Flash</h2>\n");
        if (context.getFlashScope() != null && !context.getFlashScope().getCurrentFlashCookieData().isEmpty()) {
            for (Map.Entry<String, String> entry : context.getFlashScope().getCurrentFlashCookieData().entrySet()) {
                this.appendNameValue(this.s, entry.getKey(), entry.getValue());
            }
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("<h2>Attributes</h2>\n");
        Map<String, Object> attributes = context.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.appendNameValue(this.s, entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : "null");
            }
        } else {
            this.appendNoValues(this.s);
        }
        List<Cookie> list = context.getCookies();
        if (list == null || list.isEmpty()) {
            this.s.append("<h2>Cookies</h2>\n");
            this.appendNoValues(this.s);
        } else {
            for (Cookie cookie : context.getCookies()) {
                this.s.append("<h2>Cookie: ").append(cookie.getName()).append("</h2>\n");
                this.appendNameValue(this.s, "Value", cookie.getValue());
                this.appendNameValue(this.s, "Path", cookie.getPath());
                this.appendNameValue(this.s, "Domain", cookie.getDomain());
                this.appendNameValue(this.s, "HTTP only", cookie.isHttpOnly() + "");
                this.appendNameValue(this.s, "Secure", cookie.isSecure() + "");
                this.appendNameValue(this.s, "Max age", cookie.getMaxAge() + "");
                this.appendNameValue(this.s, "Comment", cookie.getComment());
            }
        }
        this.s.append("</div>\n");
        return this;
    }

    private DiagnosticErrorRenderer appendRequest(Context context) throws IOException {
        this.s.append("<div class=\"context\">\n");
        this.s.append("<h2>Request</h2>\n");
        this.appendNameValue(this.s, "Context path", context.getContextPath());
        this.appendNameValue(this.s, "Hostname", context.getHostname());
        this.appendNameValue(this.s, "Method", context.getMethod());
        this.appendNameValue(this.s, "Remote address", context.getRemoteAddr());
        this.appendNameValue(this.s, "Content type", context.getRequestContentType());
        this.appendNameValue(this.s, "Path", context.getRequestPath());
        this.appendNameValue(this.s, "Scheme", context.getScheme());
        this.s.append("<h2>Parameters</h2>\n");
        Map<String, String[]> parameters = context.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                for (String value : entry.getValue()) {
                    this.appendNameValue(this.s, entry.getKey(), value);
                }
            }
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("<h2>Headers</h2>\n");
        Map<String, List<String>> headers = context.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    this.appendNameValue(this.s, entry.getKey(), value);
                }
            }
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("</div>\n");
        return this;
    }

    private DiagnosticErrorRenderer appendResponse(Result result) throws IOException {
        this.s.append("<div class=\"context\">\n");
        this.s.append("<h2>Application Result</h2>\n");
        if (result == null) {
            this.appendNoValues(this.s, "Application failure before a result was created");
            return this;
        }
        this.appendNameValue(this.s, "Template", result.getTemplate());
        this.appendNameValue(this.s, "Charset", result.getCharset());
        this.appendNameValue(this.s, "Content type", result.getContentType());
        this.appendNameValue(this.s, "Status code", result.getStatusCode() + "");
        List<String> supportedContentTypes = result.supportedContentTypes();
        if (supportedContentTypes == null || supportedContentTypes.isEmpty()) {
            this.appendNameValue(this.s, "Supported content types", "None set");
        } else {
            for (int i = 0; i < supportedContentTypes.size(); ++i) {
                this.appendNameValue(this.s, "Supported content type #" + i, supportedContentTypes.get(i));
            }
        }
        this.appendNameValue(this.s, "Fallback content type", (String)result.fallbackContentType().or((Object)"None set"));
        this.appendNameValue(this.s, "Json View", result.getJsonView() != null ? result.getJsonView().getClass().getCanonicalName() : "None");
        this.s.append("<h2>Renderable</h2>\n");
        Object renderable = result.getRenderable();
        if (renderable == null || renderable instanceof DiagnosticError) {
            this.appendNoValues(this.s);
        } else if (renderable instanceof Map) {
            Map map = (Map)renderable;
            for (Map.Entry entry : map.entrySet()) {
                this.appendNameValue(this.s, (String)entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : "null");
            }
        } else {
            this.appendNameValue(this.s, "Class of", renderable.getClass().getCanonicalName());
        }
        this.s.append("<h2>Headers</h2>\n");
        Map<String, String> headers = result.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<Object, Object> entry : headers.entrySet()) {
                this.appendNameValue(this.s, (String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            this.appendNoValues(this.s);
        }
        this.s.append("</div>\n");
        return this;
    }

    private void appendNameValue(StringBuilder sb, String name, String value) throws IOException {
        sb.append("<pre><span class=\"line\" style=\"width: 200px;\">");
        sb.append(this.escape(name));
        sb.append("</span><span class=\"route\" style=\"left: 210px\">");
        sb.append(this.escape(value));
        sb.append("</span></pre>");
    }

    private void appendNoValues(StringBuilder sb) throws IOException {
        this.appendNoValues(sb, "No values");
    }

    private void appendNoValues(StringBuilder sb, String title) throws IOException {
        sb.append("<pre style=\"border-bottom: 0px;\"><span style=\"position: absolute; left: 45px;\">").append(this.escape(title)).append("</span></pre><br/>");
    }

    private DiagnosticErrorRenderer appendSourceSnippet(URI sourceLocation, List<String> sourceLines, int lineNumberOfSourceLines, int lineNumberOfError) {
        if (sourceLocation != null) {
            this.s.append("    <h2>").append(this.escape(sourceLocation.toString())).append("</h2>\n");
        }
        if (sourceLines != null) {
            this.s.append("    <div>\n");
            for (int i = 0; i < sourceLines.size(); ++i) {
                this.s.append("<pre>");
                int lineNumber = lineNumberOfSourceLines + i;
                String cssClass = lineNumber == lineNumberOfError ? "line error" : "line info";
                this.s.append("<span class=\"").append(cssClass).append("\">").append(lineNumber).append("</span>");
                this.s.append("<span class=\"").append("route").append("\">").append(this.escape(sourceLines.get(i))).append("</span>");
                this.s.append("</pre>");
            }
            this.s.append("    </div>\n");
        }
        return this;
    }

    private DiagnosticErrorRenderer appendThrowable(Throwable throwable) throws IOException {
        this.s.append("<h2>Stack Trace</h2>");
        if (throwable != null) {
            this.s.append("<pre><span class=\"stacktrace\">").append(this.escape(this.throwableStackTraceToString(throwable))).append("</span></pre>\n");
        } else {
            this.appendNoValues(this.s, "Result was not triggered by an exception");
        }
        return this;
    }

    private String throwableStackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        return sw.toString();
    }

    private String escape(String value) {
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    private String getResource(String resourceName) throws IOException {
        URL url = this.getClass().getResource(resourceName);
        if (url == null) {
            throw new IOException("Unable to find diagnostic resource: " + resourceName);
        }
        return IOUtils.toString((URL)url);
    }
}

