/*
 * Decompiled with CFR 0.152.
 */
package ninja.diagnostics;

import java.io.File;
import java.io.IOException;
import ninja.Result;
import ninja.diagnostics.DiagnosticError;
import ninja.diagnostics.SourceSnippet;
import ninja.diagnostics.SourceSnippetHelper;

public class DiagnosticErrorBuilder {
    static String baseDirectory = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "java";

    public static DiagnosticError build404NotFoundDiagnosticError(boolean tryToReadLinesFromSourceCode) {
        SourceSnippet snippet = null;
        if (tryToReadLinesFromSourceCode) {
            snippet = DiagnosticErrorBuilder.tryToReadSourceSnippetInPackage("conf", "Routes.java", 0, 200);
        }
        return DiagnosticErrorBuilder.buildDiagnosticError("Route not found", null, snippet, -1, null);
    }

    public static DiagnosticError build403ForbiddenDiagnosticError() {
        return DiagnosticErrorBuilder.buildDiagnosticError("Forbidden", null, false, null);
    }

    public static DiagnosticError build401UnauthorizedDiagnosticError() {
        return DiagnosticErrorBuilder.buildDiagnosticError("Not authorized", null, false, null);
    }

    public static DiagnosticError build500InternalServerErrorDiagnosticError(Throwable cause, boolean tryToReadLinesFromSourceCode, Result underlyingResult) {
        return DiagnosticErrorBuilder.buildDiagnosticError("Application exception", cause, tryToReadLinesFromSourceCode, underlyingResult);
    }

    public static DiagnosticError build400BadRequestDiagnosticError(Throwable cause, boolean tryToReadLinesFromSourceCode) {
        return DiagnosticErrorBuilder.buildDiagnosticError("Bad request to application", cause, tryToReadLinesFromSourceCode, null);
    }

    public static DiagnosticError buildDiagnosticError(String title, Throwable throwable, boolean tryToReadLinesFromSourceCode, Result underlyingResult) {
        StackTraceElement ste;
        if (tryToReadLinesFromSourceCode && (ste = DiagnosticErrorBuilder.findFirstStackTraceElementWithSourceCodeInProject(throwable)) != null) {
            String relativeSourcePath = DiagnosticErrorBuilder.getSourceCodeRelativePathForStackTraceElement(ste);
            int lineNumberOfError = ste.getLineNumber();
            return DiagnosticErrorBuilder.buildDiagnosticError(title, throwable, relativeSourcePath, lineNumberOfError, underlyingResult);
        }
        return new DiagnosticError(title, throwable, underlyingResult);
    }

    public static DiagnosticError buildDiagnosticError(String title, Throwable throwable, String packageName, String fileName, int lineNumberOfError, Result underlyingResult) {
        String relativeSourcePath = packageName.replace(".", File.separator) + fileName;
        return DiagnosticErrorBuilder.buildDiagnosticError(title, throwable, relativeSourcePath, lineNumberOfError, underlyingResult);
    }

    public static DiagnosticError buildDiagnosticError(String title, Throwable throwable, String relativeSourcePath, int lineNumberOfError, Result underlyingResult) {
        int lineNumberFrom = lineNumberOfError - 4;
        int lineNumberTo = lineNumberOfError + 5;
        SourceSnippet snippet = DiagnosticErrorBuilder.tryToReadSourceSnippet(relativeSourcePath, lineNumberFrom, lineNumberTo);
        return DiagnosticErrorBuilder.buildDiagnosticError(title, throwable, snippet, lineNumberOfError, underlyingResult);
    }

    public static DiagnosticError buildDiagnosticError(String title, Throwable throwable, SourceSnippet snippet, int lineNumberOfError, Result underlyingResult) {
        if (snippet != null && snippet.getLines() != null && snippet.getLines().size() > 0) {
            return new DiagnosticError(title, throwable, snippet.getSourceLocation(), snippet.getLines(), snippet.getLineNumberFrom(), lineNumberOfError, underlyingResult);
        }
        return new DiagnosticError(title, throwable, underlyingResult);
    }

    public static StackTraceElement findFirstStackTraceElementWithSourceCodeInProject(Throwable throwable) {
        StackTraceElement[] stackTrace;
        if (throwable != null && (stackTrace = throwable.getStackTrace()) != null) {
            for (StackTraceElement stackTraceElement : stackTrace) {
                String sourceRelativePath = DiagnosticErrorBuilder.getSourceCodeRelativePathForStackTraceElement(stackTraceElement);
                if (!DiagnosticErrorBuilder.sourceCodeExistsInProject(sourceRelativePath)) continue;
                return stackTraceElement;
            }
        }
        return null;
    }

    public static boolean sourceCodeExistsInProject(String sourceRelativePath) {
        File sourceCodeFile = new File(baseDirectory, sourceRelativePath);
        return sourceCodeFile.exists();
    }

    public static SourceSnippet tryToReadSourceSnippetInPackage(String packageName, String fileName, int lineFrom, int lineTo) {
        try {
            return SourceSnippetHelper.readFromQualifiedSourceCodePath(new File(baseDirectory), packageName, fileName, lineFrom, lineTo);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static SourceSnippet tryToReadSourceSnippet(String sourceRelativePath, int lineFrom, int lineTo) {
        try {
            return SourceSnippetHelper.readFromRelativeFilePath(new File(baseDirectory), sourceRelativePath, lineFrom, lineTo);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getSourceCodeRelativePathForStackTraceElement(StackTraceElement ste) {
        String packageName = ste.getClassName();
        int pos = packageName.lastIndexOf(46);
        if (pos > 0) {
            packageName = packageName.substring(0, pos);
            return packageName.replace(".", File.separator) + File.separator + ste.getFileName();
        }
        return ste.getFileName();
    }
}

