/*
 * Decompiled with CFR 0.152.
 */
package ninja.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import ninja.bodyparser.BodyParserEngineJson;
import ninja.bodyparser.BodyParserEnginePost;
import ninja.bodyparser.BodyParserEngineXml;
import ninja.cache.Cache;
import ninja.cache.CacheProvider;
import ninja.jpa.JpaModule;
import ninja.migrations.MigrationEngine;
import ninja.migrations.MigrationEngineProvider;
import ninja.migrations.MigrationInitializer;
import ninja.postoffice.Postoffice;
import ninja.postoffice.PostofficeProvider;
import ninja.template.TemplateEngineFreemarker;
import ninja.template.TemplateEngineJson;
import ninja.template.TemplateEngineJsonP;
import ninja.template.TemplateEngineText;
import ninja.template.TemplateEngineXml;
import ninja.utils.NinjaProperties;
import ninja.utils.ObjectMapperProvider;
import ninja.utils.XmlMapperProvider;

public class NinjaClassicModule
extends AbstractModule {
    private final NinjaProperties ninjaProperties;
    private boolean freemarker;
    private boolean json;
    private boolean xml;
    private boolean postoffice;
    private boolean cache;
    private boolean migrations;
    private boolean jpa;

    public NinjaClassicModule(NinjaProperties ninjaProperties) {
        this(ninjaProperties, true);
    }

    public NinjaClassicModule(NinjaProperties ninjaProperties, boolean defaultEnabled) {
        this.ninjaProperties = ninjaProperties;
        this.freemarker = defaultEnabled;
        this.json = defaultEnabled;
        this.xml = defaultEnabled;
        this.postoffice = defaultEnabled;
        this.cache = defaultEnabled;
        this.migrations = defaultEnabled;
        this.jpa = defaultEnabled;
    }

    public NinjaClassicModule freemarker(boolean enabled) {
        this.freemarker = enabled;
        return this;
    }

    public NinjaClassicModule json(boolean enabled) {
        this.json = enabled;
        return this;
    }

    public NinjaClassicModule xml(boolean enabled) {
        this.xml = enabled;
        return this;
    }

    public NinjaClassicModule postoffice(boolean enabled) {
        this.postoffice = enabled;
        return this;
    }

    public NinjaClassicModule cache(boolean enabled) {
        this.cache = enabled;
        return this;
    }

    public NinjaClassicModule migrations(boolean enabled) {
        this.migrations = enabled;
        return this;
    }

    public NinjaClassicModule jpa(boolean enabled) {
        this.jpa = enabled;
        return this;
    }

    public void configure() {
        this.bind(TemplateEngineText.class);
        this.bind(BodyParserEnginePost.class);
        if (this.freemarker) {
            this.bind(TemplateEngineFreemarker.class);
        }
        if (this.json) {
            OptionalBinder.newOptionalBinder((Binder)this.binder(), ObjectMapper.class).setDefault().toProvider(ObjectMapperProvider.class).in(Singleton.class);
            this.bind(TemplateEngineJson.class);
            this.bind(TemplateEngineJsonP.class);
            this.bind(BodyParserEngineJson.class);
        }
        if (this.xml) {
            OptionalBinder.newOptionalBinder((Binder)this.binder(), XmlMapper.class).setDefault().toProvider(XmlMapperProvider.class).in(Singleton.class);
            this.bind(TemplateEngineXml.class);
            this.bind(BodyParserEngineXml.class);
        }
        if (this.postoffice) {
            this.bind(Postoffice.class).toProvider(PostofficeProvider.class);
        }
        if (this.cache) {
            this.bind(Cache.class).toProvider(CacheProvider.class);
        }
        if (this.migrations) {
            this.bind(MigrationEngine.class).toProvider(MigrationEngineProvider.class);
            this.bind(MigrationInitializer.class).asEagerSingleton();
        }
        if (this.jpa) {
            this.install((Module)new JpaModule(this.ninjaProperties));
        }
    }
}

