/*
 * Decompiled with CFR 0.152.
 */
package ninja.conf;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import ninja.RouteBuilder;
import ninja.RouteBuilderImpl;
import ninja.Router;
import ninja.RouterImpl;
import ninja.lifecycle.LifecycleSupport;
import ninja.params.ParamParser;
import ninja.scheduler.SchedulerSupport;
import ninja.utils.LoggerProvider;
import ninja.utils.NinjaProperties;
import ninja.utils.NinjaPropertiesImpl;
import org.slf4j.Logger;

public class NinjaBaseModule
extends AbstractModule {
    private final NinjaPropertiesImpl ninjaProperties;

    public NinjaBaseModule(NinjaPropertiesImpl ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    public void configure() {
        System.setProperty("file.encoding", "utf-8");
        this.install(LifecycleSupport.getModule());
        this.install(SchedulerSupport.getModule());
        Multibinder.newSetBinder((Binder)this.binder(), ParamParser.class);
        this.bind(RouteBuilder.class).to(RouteBuilderImpl.class);
        this.bind(Router.class).to(RouterImpl.class).in(Singleton.class);
        this.bind(Logger.class).toProvider(LoggerProvider.class);
        this.ninjaProperties.bindProperties(this.binder());
        this.bind(NinjaProperties.class).toInstance((Object)this.ninjaProperties);
    }
}

