/*
 * Decompiled with CFR 0.152.
 */
package ninja.cache;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import ninja.cache.Cache;
import ninja.utils.ImplFromPropertiesFactory;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheProvider
implements Provider<Cache> {
    private static final Logger logger = LoggerFactory.getLogger(CacheProvider.class);
    private final ImplFromPropertiesFactory<Cache> factory;
    private final Supplier<Cache> supplier;

    @Inject
    public CacheProvider(Injector injector, NinjaProperties ninjaProperties) {
        this.factory = new ImplFromPropertiesFactory<Cache>(injector, ninjaProperties, "cache.implementation", Cache.class, "ninja.cache.CacheEhCacheImpl", true, logger);
        this.supplier = Suppliers.memoize((Supplier)new Supplier<Cache>(){

            public Cache get() {
                return (Cache)CacheProvider.this.factory.create();
            }
        });
    }

    public Cache get() {
        return (Cache)this.supplier.get();
    }
}

