/*
 * Decompiled with CFR 0.152.
 */
package ninja.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import ninja.cache.Cache;
import ninja.lifecycle.Dispose;
import org.slf4j.Logger;

@Singleton
public class CacheEhCacheImpl
implements Cache {
    private final CacheManager ehCacheManager;
    private final net.sf.ehcache.Cache ehCache;
    private final String cacheName = "ninja";
    private final Logger logger;

    @Inject
    public CacheEhCacheImpl(Logger logger) {
        this.logger = logger;
        this.ehCacheManager = CacheManager.create();
        this.ehCacheManager.addCacheIfAbsent("ninja");
        this.ehCache = this.ehCacheManager.getCache("ninja");
    }

    @Override
    public void add(String key, Object value, int expiration) {
        if (this.ehCache.get((Serializable)((Object)key)) != null) {
            return;
        }
        Element element = new Element((Object)key, value);
        element.setTimeToLive(expiration);
        this.ehCache.put(element);
    }

    @Override
    public void clear() {
        this.ehCache.removeAll();
    }

    @Override
    public synchronized long decr(String key, int by) {
        Element e = this.ehCache.get((Serializable)((Object)key));
        if (e == null) {
            return -1L;
        }
        long newValue = ((Number)e.getObjectValue()).longValue() - (long)by;
        Element newE = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(newValue));
        newE.setTimeToLive(e.getTimeToLive());
        this.ehCache.put(newE);
        return newValue;
    }

    @Override
    public void delete(String key) {
        this.ehCache.remove((Serializable)((Object)key));
    }

    @Override
    public Object get(String key) {
        Element e = this.ehCache.get((Serializable)((Object)key));
        return e == null ? null : e.getObjectValue();
    }

    @Override
    public Map<String, Object> get(String[] keys) {
        HashMap<String, Object> result = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public synchronized long incr(String key, int by) {
        Element e = this.ehCache.get((Serializable)((Object)key));
        if (e == null) {
            return -1L;
        }
        long newValue = ((Number)e.getObjectValue()).longValue() + (long)by;
        Element newE = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(newValue));
        newE.setTimeToLive(e.getTimeToLive());
        this.ehCache.put(newE);
        return newValue;
    }

    @Override
    public void replace(String key, Object value, int expiration) {
        if (this.ehCache.get((Serializable)((Object)key)) == null) {
            return;
        }
        Element element = new Element((Object)key, value);
        element.setTimeToLive(expiration);
        this.ehCache.put(element);
    }

    @Override
    public boolean safeAdd(String key, Object value, int expiration) {
        try {
            this.add(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean safeDelete(String key) {
        try {
            this.delete(key);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean safeReplace(String key, Object value, int expiration) {
        try {
            this.replace(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean safeSet(String key, Object value, int expiration) {
        try {
            this.set(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void set(String key, Object value, int expiration) {
        Element element = new Element((Object)key, value);
        element.setTimeToLive(expiration);
        this.ehCache.put(element);
    }

    @Dispose
    public void stop() {
        if (this.ehCacheManager != null) {
            this.ehCacheManager.shutdown();
        }
    }
}

