/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Injector;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import ninja.Filter;
import ninja.FilterChain;
import ninja.FilterChainEnd;
import ninja.FilterChainImpl;
import ninja.FilterWith;
import ninja.Result;
import ninja.Route;
import ninja.RouteBuilder;
import ninja.params.ControllerMethodInvoker;
import ninja.utils.MethodReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBuilderImpl
implements RouteBuilder {
    private static final Logger log = LoggerFactory.getLogger(RouteBuilder.class);
    private String httpMethod;
    private String uri;
    private Class controller;
    private Method controllerMethod;
    private Result result;

    public RouteBuilderImpl GET() {
        this.httpMethod = "GET";
        return this;
    }

    public RouteBuilderImpl POST() {
        this.httpMethod = "POST";
        return this;
    }

    public RouteBuilderImpl PUT() {
        this.httpMethod = "PUT";
        return this;
    }

    public RouteBuilderImpl DELETE() {
        this.httpMethod = "DELETE";
        return this;
    }

    public RouteBuilderImpl OPTIONS() {
        this.httpMethod = "OPTIONS";
        return this;
    }

    public RouteBuilderImpl HEAD() {
        this.httpMethod = "HEAD";
        return this;
    }

    public RouteBuilderImpl METHOD(String method) {
        this.httpMethod = method;
        return this;
    }

    @Override
    public void with(Class controller, String controllerMethod) {
        this.controller = controller;
        this.controllerMethod = this.verifyThatControllerAndMethodExists(controller, controllerMethod);
    }

    @Override
    public void with(MethodReference controllerMethodRef) {
        this.with(controllerMethodRef.getDeclaringClass(), controllerMethodRef.getMethodName());
    }

    @Override
    public void with(Result result) {
        this.result = result;
    }

    @Override
    public RouteBuilder route(String uri) {
        this.uri = uri;
        return this;
    }

    private Method verifyThatControllerAndMethodExists(Class controller, String controllerMethod) {
        try {
            Method methodFromQueryingClass = null;
            for (Method method : controller.getMethods()) {
                if (!method.getName().equals(controllerMethod)) continue;
                if (methodFromQueryingClass == null) {
                    methodFromQueryingClass = method;
                    continue;
                }
                throw new NoSuchMethodException();
            }
            if (methodFromQueryingClass == null) {
                throw new NoSuchMethodException();
            }
            if (Result.class.isAssignableFrom(methodFromQueryingClass.getReturnType())) {
                return methodFromQueryingClass;
            }
            throw new NoSuchMethodException();
        }
        catch (SecurityException e) {
            log.error("Error while checking for valid Controller / controllerMethod combination", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("Error in route configuration!!!");
            log.error("Can not find Controller " + controller.getName() + " and method " + controllerMethod);
            log.error("Hint: make sure the controller returns a ninja.Result!");
            log.error("Hint: Ninja does not allow more than one method with the same name!");
        }
        return null;
    }

    public Route buildRoute(Injector injector) {
        if (this.controller == null && this.result == null) {
            log.error("Error in route configuration for {}", (Object)this.uri);
            throw new IllegalStateException("Route not with a controller or result");
        }
        LinkedList<Class<? extends Filter>> filters = new LinkedList<Class<? extends Filter>>();
        if (this.controller != null) {
            if (this.controllerMethod == null) {
                throw new IllegalStateException(String.format("Route '%s' does not have a controller method", this.uri));
            }
            filters.addAll(this.calculateFiltersForClass(this.controller));
            FilterWith filterWith = this.controllerMethod.getAnnotation(FilterWith.class);
            if (filterWith != null) {
                filters.addAll(Arrays.asList(filterWith.value()));
            }
        }
        return new Route(this.httpMethod, this.uri, this.controller, this.controllerMethod, this.buildFilterChain(injector, filters, this.controller, this.controllerMethod, this.result));
    }

    private FilterChain buildFilterChain(Injector injector, LinkedList<Class<? extends Filter>> filters, Class<?> controller, Method controllerMethod, Result result) {
        if (filters.isEmpty()) {
            return result != null ? new FilterChainEnd(result) : new FilterChainEnd(injector.getProvider(controller), ControllerMethodInvoker.build(controllerMethod, injector));
        }
        Class<? extends Filter> filter = filters.pop();
        return new FilterChainImpl((Provider<? extends Filter>)injector.getProvider(filter), this.buildFilterChain(injector, filters, controller, controllerMethod, result));
    }

    private Set<Class<? extends Filter>> calculateFiltersForClass(Class controller) {
        FilterWith filterWith;
        LinkedHashSet<Class<? extends Filter>> filters = new LinkedHashSet<Class<? extends Filter>>();
        if (controller.getSuperclass() != null) {
            filters.addAll(this.calculateFiltersForClass(controller.getSuperclass()));
        }
        if (controller.getInterfaces() != null) {
            for (Class<?> clazz : controller.getInterfaces()) {
                filters.addAll(this.calculateFiltersForClass(clazz));
            }
        }
        if ((filterWith = controller.getAnnotation(FilterWith.class)) != null) {
            filters.addAll(Arrays.asList(filterWith.value()));
        }
        return filters;
    }
}

