/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.FilterChain;

public class Route {
    static final Pattern PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE = Pattern.compile("\\{(.*?)(:\\s(.*?))?\\}");
    static final String VARIABLE_ROUTES_DEFAULT_REGEX = "([^/]*)";
    private final String httpMethod;
    private final String uri;
    private final Class controllerClass;
    private final Method controllerMethod;
    private final FilterChain filterChain;
    private final List<String> parameterNames;
    private final Pattern regex;

    public Route(String httpMethod, String uri, Class controllerClass, Method controllerMethod, FilterChain filterChain) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.controllerClass = controllerClass;
        this.controllerMethod = controllerMethod;
        this.filterChain = filterChain;
        this.parameterNames = ImmutableList.copyOf(Route.doParseParameters(uri));
        this.regex = Pattern.compile(Route.convertRawUriToRegex(uri));
    }

    public String getUrl() {
        return this.uri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public Method getControllerMethod() {
        return this.controllerMethod;
    }

    public boolean matches(String httpMethod, String uri) {
        if (this.httpMethod.equalsIgnoreCase(httpMethod)) {
            Matcher matcher = this.regex.matcher(uri);
            return matcher.matches();
        }
        return false;
    }

    public Map<String, String> getPathParametersEncoded(String uri) {
        HashMap map = Maps.newHashMap();
        Matcher m = this.regex.matcher(uri);
        if (m.matches()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                map.put(this.parameterNames.get(i - 1), m.group(i));
            }
        }
        return map;
    }

    private static List<String> doParseParameters(String rawRoute) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(rawRoute);
        while (m.find()) {
            list.add(m.group(1));
        }
        return list;
    }

    protected static String convertRawUriToRegex(String rawUri) {
        Matcher groupMatcher = Pattern.compile("\\(([^?].*)\\)").matcher(rawUri);
        String converted = groupMatcher.replaceAll("\\(?:$1\\)");
        Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(converted);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String namedVariablePartOfRoute = matcher.group(3);
            String namedVariablePartOfORouteReplacedWithRegex = namedVariablePartOfRoute != null ? "(" + Matcher.quoteReplacement(namedVariablePartOfRoute) + ")" : VARIABLE_ROUTES_DEFAULT_REGEX;
            matcher.appendReplacement(stringBuffer, namedVariablePartOfORouteReplacedWithRegex);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

