/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Inject;
import java.nio.charset.Charset;
import ninja.Context;
import ninja.Filter;
import ninja.FilterChain;
import ninja.Ninja;
import ninja.Result;
import ninja.UsernamePasswordValidator;
import ninja.utils.NinjaProperties;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthFilter
implements Filter {
    protected final Ninja ninja;
    protected final UsernamePasswordValidator credentialsValidator;
    protected final String challenge;
    protected final String realm;

    @Inject
    public BasicAuthFilter(Ninja ninja, NinjaProperties ninjaProperties, UsernamePasswordValidator validator) {
        this.ninja = ninja;
        this.credentialsValidator = validator;
        this.realm = ninjaProperties.getWithDefault("application.name", "Ninja");
        this.challenge = "Basic realm=\"" + this.realm + "\"";
    }

    @Override
    public Result filter(FilterChain chain, Context context) {
        if (context.getSession() == null) {
            return this.ninja.getUnauthorizedResult(context);
        }
        if (context.getSession().get("username") == null) {
            String password;
            String packet;
            String credentials;
            String[] values;
            String username;
            String header = context.getHeader("Authorization");
            if (header != null && header.startsWith("Basic") && this.credentialsValidator.validateCredentials(username = (values = (credentials = new String(Base64.decodeBase64((String)(packet = header.substring("Basic".length()).trim())), Charset.forName("utf-8"))).split(":", 2))[0], password = values[1])) {
                context.getSession().put("username", username);
                return chain.next(context);
            }
            Result result = this.ninja.getUnauthorizedResult(context).addHeader("WWW-Authenticate", this.challenge);
            return result;
        }
        return chain.next(context);
    }
}

