/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.defaults;

import java.util.HashMap;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

public class RawSqlSource
implements SqlSource {
    private final SqlSource sqlSource;

    public RawSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        this(configuration, RawSqlSource.getString(script), parameterType);
    }

    public RawSqlSource(Configuration configuration, String sql, Class<?> parameterType) {
        SqlSourceBuilder sqlSourceParser = new SqlSourceBuilder(configuration);
        Class clazz = parameterType == null ? Object.class : parameterType;
        this.sqlSource = sqlSourceParser.parse(sql, clazz, new HashMap<String, Object>());
    }

    private static String getString(XNode script) {
        StringBuilder contents = new StringBuilder();
        NodeList children = script.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = script.newXNode(children.item(i));
            if (child.getNode().getNodeType() != 4 && child.getNode().getNodeType() != 3) continue;
            String data = child.getStringBody("");
            contents.append(data);
        }
        return contents.toString();
    }

    @Override
    public BoundSql getBoundSql(Object parameterObject) {
        return this.sqlSource.getBoundSql(parameterObject);
    }
}

