/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemcachedConfiguration {
    private String keyPrefix;
    private ConnectionFactory connectionFactory;
    private List<InetSocketAddress> addresses;
    private boolean usingAsyncGet;
    private boolean compressionEnabled;
    private int expiration;
    private int timeout;
    private TimeUnit timeUnit;

    MemcachedConfiguration() {
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public List<InetSocketAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<InetSocketAddress> addresses) {
        this.addresses = addresses;
    }

    public boolean isUsingAsyncGet() {
        return this.usingAsyncGet;
    }

    public void setUsingAsyncGet(boolean usingAsyncGet) {
        this.usingAsyncGet = usingAsyncGet;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int hashCode() {
        return MemcachedConfiguration.hash(1, 31, new Object[]{this.addresses, this.compressionEnabled, this.connectionFactory, this.expiration, this.keyPrefix, this.timeUnit, this.timeout, this.usingAsyncGet});
    }

    public static int hash(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object ... objs) {
        int result = initialNonZeroOddNumber;
        for (Object obj : objs) {
            result = multiplierNonZeroOddNumber * result + (obj != null ? obj.hashCode() : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemcachedConfiguration other = (MemcachedConfiguration)obj;
        return MemcachedConfiguration.eq(this.addresses, other.addresses) && MemcachedConfiguration.eq(this.compressionEnabled, other.compressionEnabled) && MemcachedConfiguration.eq(this.connectionFactory, other.connectionFactory) && MemcachedConfiguration.eq(this.expiration, other.expiration) && MemcachedConfiguration.eq(this.keyPrefix, other.keyPrefix) && MemcachedConfiguration.eq(this.timeUnit, other.timeUnit) && MemcachedConfiguration.eq(this.timeout, other.timeout) && MemcachedConfiguration.eq(this.usingAsyncGet, other.usingAsyncGet);
    }

    private static <O> boolean eq(O o1, O o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public String toString() {
        return String.format("MemcachedConfiguration [addresses=%s, compressionEnabled=%s, connectionFactory=%s, , expiration=%s, keyPrefix=%s, timeUnit=%s, timeout=%s, usingAsyncGet=%s]", new Object[]{this.addresses, this.compressionEnabled, this.connectionFactory, this.expiration, this.keyPrefix, this.timeUnit, this.timeout, this.usingAsyncGet});
    }
}

