/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.mybatis.caches.memcached.DummyReadWriteLock;
import org.mybatis.caches.memcached.MemcachedClientWrapper;

public final class MemcachedCache
implements Cache {
    private static final MemcachedClientWrapper MEMCACHED_CLIENT = new MemcachedClientWrapper();
    private final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    private final String id;

    public MemcachedCache(String id) {
        this.id = id;
    }

    public void clear() {
        MEMCACHED_CLIENT.removeGroup(this.id);
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        return MEMCACHED_CLIENT.getObject(key);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        return Integer.MAX_VALUE;
    }

    public void putObject(Object key, Object value) {
        MEMCACHED_CLIENT.putObject(key, value, this.id);
    }

    public Object removeObject(Object key) {
        return MEMCACHED_CLIENT.removeObject(key);
    }
}

