/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mybatis.caches.memcached.MemcachedConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPropertySetter<T> {
    private static Map<String, Method> WRITERS = new HashMap<String, Method>();
    private final String propertyKey;
    private final String propertyName;
    private final Method propertyWriterMethod;
    private final T defaultValue;

    public AbstractPropertySetter(String propertyKey, String propertyName, T defaultValue) {
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyWriterMethod = WRITERS.get(propertyName);
        if (this.propertyWriterMethod == null) {
            throw new RuntimeException("Class '" + MemcachedConfiguration.class.getName() + "' doesn't contain a property '" + propertyName + "'");
        }
        this.defaultValue = defaultValue;
    }

    public final void set(Properties config, MemcachedConfiguration memcachedConfiguration) {
        T value;
        String propertyValue = config.getProperty(this.propertyKey);
        try {
            value = this.convert(propertyValue);
            if (value == null) {
                value = this.defaultValue;
            }
        }
        catch (Throwable e) {
            value = this.defaultValue;
        }
        try {
            this.propertyWriterMethod.invoke((Object)memcachedConfiguration, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Impossible to set property '" + this.propertyName + "' with value '" + value + "', extracted from ('" + this.propertyKey + "'=" + propertyValue + ")", e);
        }
    }

    protected abstract T convert(String var1) throws Throwable;

    static {
        try {
            BeanInfo memcachedConfigInfo = Introspector.getBeanInfo(MemcachedConfiguration.class);
            for (PropertyDescriptor descriptor : memcachedConfigInfo.getPropertyDescriptors()) {
                WRITERS.put(descriptor.getName(), descriptor.getWriteMethod());
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }
}

