/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private CharBuffer out = CharBuffer.allocate(1024);
    private static final Charset DEFAULT_CHARSET = WriterOutputStream.getDefaultCharset();

    public WriterOutputStream(Writer out, Charset charset) {
        this.writer = out;
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public WriterOutputStream(Writer out) {
        this(out, DEFAULT_CHARSET);
    }

    public void write(int b) throws IOException {
        if (this.buf.remaining() == 0) {
            this.decode(false);
        }
        this.buf.put((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.buf.remaining() == 0) {
                this.decode(false);
            }
            int sz = Math.min(this.buf.remaining(), len);
            this.buf.put(b, off, sz);
            off += sz;
            len -= sz;
        }
    }

    public void flush() throws IOException {
        this.decode(false);
        this.flushOutput();
        this.writer.flush();
    }

    private void flushOutput() throws IOException {
        this.writer.write(this.out.array(), 0, this.out.position());
        this.out.clear();
    }

    public void close() throws IOException {
        this.decode(true);
        this.flushOutput();
        this.writer.close();
        this.buf.rewind();
    }

    private void decode(boolean last) throws IOException {
        this.buf.flip();
        while (true) {
            CoderResult r;
            if ((r = this.decoder.decode(this.buf, this.out, last)) == CoderResult.OVERFLOW) {
                this.flushOutput();
                continue;
            }
            if (r == CoderResult.UNDERFLOW) {
                this.buf.compact();
                return;
            }
            r.throwException();
        }
    }

    private static Charset getDefaultCharset() {
        try {
            String encoding = System.getProperty("file.encoding");
            return Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException e) {
            return Charset.forName("UTF-8");
        }
    }
}

