/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public final class CharSpool
extends Writer {
    private List<char[]> buf;
    private char[] last = new char[1024];
    private int pos;

    public void write(char[] cbuf, int off, int len) {
        while (len > 0) {
            int sz = Math.min(this.last.length - this.pos, len);
            System.arraycopy(cbuf, off, this.last, this.pos, sz);
            len -= sz;
            off += sz;
            this.pos += sz;
            this.renew();
        }
    }

    private void renew() {
        if (this.pos < this.last.length) {
            return;
        }
        if (this.buf == null) {
            this.buf = new LinkedList<char[]>();
        }
        this.buf.add(this.last);
        this.last = new char[1024];
        this.pos = 0;
    }

    public void write(int c) {
        this.renew();
        this.last[this.pos++] = (char)c;
    }

    public void flush() {
    }

    public void close() {
    }

    public void writeTo(Writer w) throws IOException {
        if (this.buf != null) {
            for (char[] cb : this.buf) {
                w.write(cb);
            }
        }
        w.write(this.last, 0, this.pos);
    }
}

