/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteBuffer
extends OutputStream {
    private byte[] buf = new byte[8192];
    private int size = 0;

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        System.arraycopy(b, off, this.buf, this.size, len);
        this.size += len;
    }

    public synchronized void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.buf[this.size++] = (byte)b;
    }

    public synchronized long length() {
        return this.size;
    }

    private void ensureCapacity(int len) {
        if (this.buf.length - this.size > len) {
            return;
        }
        byte[] n = new byte[Math.max(this.buf.length * 2, this.size + len)];
        System.arraycopy(this.buf, 0, n, 0, this.size);
        this.buf = n;
    }

    public synchronized String toString() {
        return new String(this.buf, 0, this.size);
    }

    public synchronized void writeTo(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.size);
    }

    public InputStream newInputStream() {
        return new InputStream(){
            private int pos = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                ByteBuffer byteBuffer = ByteBuffer.this;
                synchronized (byteBuffer) {
                    if (this.pos >= ByteBuffer.this.size) {
                        return -1;
                    }
                    return ByteBuffer.this.buf[this.pos++];
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] b, int off, int len) throws IOException {
                ByteBuffer byteBuffer = ByteBuffer.this;
                synchronized (byteBuffer) {
                    if (ByteBuffer.this.size == this.pos) {
                        return -1;
                    }
                    int sz = Math.min(len, ByteBuffer.this.size - this.pos);
                    System.arraycopy(ByteBuffer.this.buf, this.pos, b, off, sz);
                    this.pos += sz;
                    return sz;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int available() throws IOException {
                ByteBuffer byteBuffer = ByteBuffer.this;
                synchronized (byteBuffer) {
                    return ByteBuffer.this.size - this.pos;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long skip(long n) throws IOException {
                ByteBuffer byteBuffer = ByteBuffer.this;
                synchronized (byteBuffer) {
                    int diff = (int)Math.min(n, (long)(ByteBuffer.this.size - this.pos));
                    this.pos += diff;
                    return diff;
                }
            }
        };
    }
}

