/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    private static final TypeVisitor<Class, Void> eraser = new TypeVisitor<Class, Void>(){

        @Override
        public Class onClass(Class c, Void _) {
            return c;
        }

        @Override
        public Class onParameterizdType(ParameterizedType p, Void _) {
            return (Class)this.visit(p.getRawType(), null);
        }

        @Override
        public Class onGenericArray(GenericArrayType g, Void _) {
            return Array.newInstance((Class)this.visit(g.getGenericComponentType(), null), 0).getClass();
        }

        @Override
        public Class onVariable(TypeVariable v, Void _) {
            return (Class)this.visit(v.getBounds()[0], null);
        }

        @Override
        public Class onWildcard(WildcardType w, Void _) {
            return (Class)this.visit(w.getUpperBounds()[0], null);
        }
    };
    private static final TypeVisitor<Type, Class> baseClassFinder = new TypeVisitor<Type, Class>(){

        @Override
        public Type onClass(Class c, Class sup) {
            Type r;
            if (sup == c) {
                return sup;
            }
            Type sc = c.getGenericSuperclass();
            if (sc != null && (r = (Type)this.visit(sc, sup)) != null) {
                return r;
            }
            for (Type i : c.getGenericInterfaces()) {
                r = (Type)this.visit(i, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, Class sup) {
            Class raw = (Class)p.getRawType();
            if (raw == sup) {
                return p;
            }
            Type r = raw.getGenericSuperclass();
            if (r != null) {
                r = (Type)this.visit(this.bind(r, raw, p), sup);
            }
            if (r != null) {
                return r;
            }
            for (Type i : raw.getGenericInterfaces()) {
                r = (Type)this.visit(this.bind(i, raw, p), sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onGenericArray(GenericArrayType g, Class sup) {
            return null;
        }

        @Override
        public Type onVariable(TypeVariable v, Class sup) {
            return (Type)this.visit(v.getBounds()[0], sup);
        }

        @Override
        public Type onWildcard(WildcardType w, Class sup) {
            return null;
        }

        private Type bind(Type t, GenericDeclaration decl, ParameterizedType args) {
            return (Type)binder.visit(t, new BinderArg(decl, args.getActualTypeArguments()));
        }
    };
    private static final TypeVisitor<Type, BinderArg> binder = new TypeVisitor<Type, BinderArg>(){

        @Override
        public Type onClass(Class c, BinderArg args) {
            return c;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, BinderArg args) {
            Type[] params = p.getActualTypeArguments();
            boolean different = false;
            for (int i = 0; i < params.length; ++i) {
                Type t = params[i];
                params[i] = (Type)this.visit(t, args);
                different |= t != params[i];
            }
            Type newOwner = p.getOwnerType();
            if (newOwner != null) {
                newOwner = (Type)this.visit(newOwner, args);
            }
            if (!(different |= p.getOwnerType() != newOwner)) {
                return p;
            }
            return new ParameterizedTypeImpl((Class)p.getRawType(), params, newOwner);
        }

        @Override
        public Type onGenericArray(GenericArrayType g, BinderArg types) {
            Type c = (Type)this.visit(g.getGenericComponentType(), types);
            if (c == g.getGenericComponentType()) {
                return g;
            }
            return new GenericArrayTypeImpl(c);
        }

        @Override
        public Type onVariable(TypeVariable v, BinderArg types) {
            return types.replace(v);
        }

        @Override
        public Type onWildcard(WildcardType w, BinderArg types) {
            Type t;
            int i;
            Type[] lb = w.getLowerBounds();
            Type[] ub = w.getUpperBounds();
            boolean diff = false;
            for (i = 0; i < lb.length; ++i) {
                t = lb[i];
                lb[i] = (Type)this.visit(t, types);
                diff |= t != lb[i];
            }
            for (i = 0; i < ub.length; ++i) {
                t = ub[i];
                ub[i] = (Type)this.visit(t, types);
                diff |= t != ub[i];
            }
            if (!diff) {
                return w;
            }
            return new WildcardTypeImpl(lb, ub);
        }
    };

    public static <T> Class<T> erasure(Type t) {
        return eraser.visit(t, null);
    }

    public static Type getBaseClass(Type type, Class baseType) {
        return baseClassFinder.visit(type, baseType);
    }

    public static Type getTypeArgument(Type type, int i) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return TypeUtil.fix(p.getActualTypeArguments()[i]);
        }
        throw new IllegalArgumentException();
    }

    private static Type fix(Type t) {
        if (!(t instanceof GenericArrayType)) {
            return t;
        }
        GenericArrayType gat = (GenericArrayType)t;
        if (gat.getGenericComponentType() instanceof Class) {
            Class c = (Class)gat.getGenericComponentType();
            return Array.newInstance(c, 0).getClass();
        }
        return t;
    }

    static final class WildcardTypeImpl
    implements WildcardType {
        private final Type[] ub;
        private final Type[] lb;

        public WildcardTypeImpl(Type[] ub, Type[] lb) {
            this.ub = ub;
            this.lb = lb;
        }

        public Type[] getUpperBounds() {
            return this.ub;
        }

        public Type[] getLowerBounds() {
            return this.lb;
        }

        public int hashCode() {
            return Arrays.hashCode(this.lb) ^ Arrays.hashCode(this.ub);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WildcardType) {
                WildcardType that = (WildcardType)obj;
                return Arrays.equals(that.getLowerBounds(), this.lb) && Arrays.equals(that.getUpperBounds(), this.ub);
            }
            return false;
        }
    }

    static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private Type genericComponentType;

        GenericArrayTypeImpl(Type ct) {
            assert (ct != null);
            this.genericComponentType = ct;
        }

        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public String toString() {
            Type componentType = this.getGenericComponentType();
            StringBuilder sb = new StringBuilder();
            if (componentType instanceof Class) {
                sb.append(((Class)componentType).getName());
            } else {
                sb.append(componentType.toString());
            }
            sb.append("[]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof GenericArrayType) {
                GenericArrayType that = (GenericArrayType)o;
                Type thatComponentType = that.getGenericComponentType();
                return this.genericComponentType.equals(thatComponentType);
            }
            return false;
        }

        public int hashCode() {
            return this.genericComponentType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private Type[] actualTypeArguments;
        private Class<?> rawType;
        private Type ownerType;

        ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
            this.actualTypeArguments = actualTypeArguments;
            this.rawType = rawType;
            this.ownerType = ownerType != null ? ownerType : rawType.getDeclaringClass();
            this.validateConstructorArguments();
        }

        private void validateConstructorArguments() {
            TypeVariable<Class<?>>[] formals = this.rawType.getTypeParameters();
            if (formals.length != this.actualTypeArguments.length) {
                throw new MalformedParameterizedTypeException();
            }
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.actualTypeArguments.clone();
        }

        @Override
        public Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (o instanceof ParameterizedType) {
                ParameterizedType that = (ParameterizedType)o;
                if (this == that) {
                    return true;
                }
                Type thatOwner = that.getOwnerType();
                Type thatRawType = that.getRawType();
                return (this.ownerType == null ? thatOwner == null : this.ownerType.equals(thatOwner)) && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                if (this.ownerType instanceof Class) {
                    sb.append(((Class)this.ownerType).getName());
                } else {
                    sb.append(this.ownerType.toString());
                }
                sb.append(".");
                if (this.ownerType instanceof ParameterizedTypeImpl) {
                    sb.append(this.rawType.getName().replace(((ParameterizedTypeImpl)this.ownerType).rawType.getName() + "$", ""));
                } else {
                    sb.append(this.rawType.getName());
                }
            } else {
                sb.append(this.rawType.getName());
            }
            if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
                sb.append("<");
                boolean first = true;
                for (Type t : this.actualTypeArguments) {
                    if (!first) {
                        sb.append(", ");
                    }
                    if (t instanceof Class) {
                        sb.append(((Class)t).getName());
                    } else {
                        sb.append(t.toString());
                    }
                    first = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    private static class BinderArg {
        final TypeVariable[] params;
        final Type[] args;

        BinderArg(TypeVariable[] params, Type[] args) {
            this.params = params;
            this.args = args;
            assert (params.length == args.length);
        }

        public BinderArg(GenericDeclaration decl, Type[] args) {
            this(decl.getTypeParameters(), args);
        }

        Type replace(TypeVariable v) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] != v) continue;
                return this.args[i];
            }
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TypeVisitor<T, P> {
        TypeVisitor() {
        }

        public final T visit(Type t, P param) {
            assert (t != null);
            if (t instanceof Class) {
                return this.onClass((Class)t, param);
            }
            if (t instanceof ParameterizedType) {
                return this.onParameterizdType((ParameterizedType)t, param);
            }
            if (t instanceof GenericArrayType) {
                return this.onGenericArray((GenericArrayType)t, param);
            }
            if (t instanceof WildcardType) {
                return this.onWildcard((WildcardType)t, param);
            }
            if (t instanceof TypeVariable) {
                return this.onVariable((TypeVariable)t, param);
            }
            assert (false);
            throw new IllegalArgumentException();
        }

        protected abstract T onClass(Class var1, P var2);

        protected abstract T onParameterizdType(ParameterizedType var1, P var2);

        protected abstract T onGenericArray(GenericArrayType var1, P var2);

        protected abstract T onVariable(TypeVariable var1, P var2);

        protected abstract T onWildcard(WildcardType var1, P var2);
    }
}

