/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.StringTokenizer;

public final class TokenList {
    public final String[] tokens;
    public int idx;

    TokenList(String url) {
        StringTokenizer tknzr = new StringTokenizer(url, "/");
        this.tokens = new String[tknzr.countTokens()];
        int i = 0;
        while (tknzr.hasMoreTokens()) {
            this.tokens[i++] = tknzr.nextToken();
        }
    }

    public boolean hasMore() {
        return this.tokens.length != this.idx;
    }

    public String peek() {
        if (this.hasMore()) {
            return this.tokens[this.idx];
        }
        return null;
    }

    public String next() {
        return this.tokens[this.idx++];
    }

    public String prev() {
        return this.tokens[--this.idx];
    }

    public int nextAsInt() throws NumberFormatException {
        String p = this.peek();
        if (p == null) {
            throw new NumberFormatException();
        }
        int i = Integer.valueOf(p);
        ++this.idx;
        return i;
    }

    public int length() {
        return this.tokens.length;
    }

    public String get(int i) {
        return this.tokens[i];
    }

    public int countRemainingTokens() {
        return this.length() - this.idx;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tokens.length; ++i) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            if (i == this.idx) {
                buf.append('!');
            }
            buf.append(this.tokens[i]);
        }
        return buf.toString();
    }

    public String assembleRestOfPath() {
        StringBuilder buf = new StringBuilder();
        for (int i = this.idx; i < this.length(); ++i) {
            buf.append('/');
            buf.append(this.tokens[i]);
        }
        return buf.toString();
    }
}

