/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.NameBasedDispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.TearOffSupport;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;

public class MetaClass
extends TearOffSupport {
    public final Class clazz;
    public final MetaClassLoader classLoader;
    public final List<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
    public final MetaClass baseClass;
    public final WebApp webApp;
    public static boolean NO_CACHE = false;

    MetaClass(WebApp webApp, Class clazz) {
        this.clazz = clazz;
        this.webApp = webApp;
        this.baseClass = webApp.getMetaClass(clazz.getSuperclass());
        this.classLoader = MetaClassLoader.get(clazz.getClassLoader());
        this.buildDispatchers(new ClassDescriptor(clazz, null));
    }

    private void buildDispatchers(ClassDescriptor node) {
        String name;
        for (final Function function : node.methods.prefix("do")) {
            WebMethod a = function.getAnnotation(WebMethod.class);
            String[] names = a != null && a.name().length > 0 ? a.name() : new String[]{MetaClass.camelize(function.getName().substring(2))};
            for (String name2 : names) {
                this.dispatchers.add(new NameBasedDispatcher(name2, 0){

                    public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                        Object o;
                        if (1.traceable()) {
                            1.trace(req, rsp, "-> <%s>.%s(...)", node, function.getName());
                        }
                        if ((o = function.bindAndInvoke(node, req, rsp)) instanceof HttpResponse) {
                            HttpResponse response = (HttpResponse)o;
                            response.generateResponse(req, rsp, node);
                        }
                    }

                    public String toString() {
                        return function.getQualifiedName() + "(...) for url=/" + this.name + "/...";
                    }
                });
            }
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildViewDispatchers(this, this.dispatchers);
        }
        for (final Function function : node.methods.signature(StaplerRequest.class, StaplerResponse.class).name("doIndex")) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException {
                    if (req.tokens.hasMore()) {
                        return false;
                    }
                    if (2.traceable()) {
                        2.trace(req, rsp, "-> <%s>.doIndex(...)", node);
                    }
                    function.invoke(req, node, req, rsp);
                    return true;
                }

                public String toString() {
                    return function.getQualifiedName() + "(StaplerRequest,StaplerResponse) for url=/";
                }
            });
        }
        for (final Field f : node.fields) {
            this.dispatchers.add(new NameBasedDispatcher(f.getName()){
                final String role;
                {
                    super(x0);
                    this.role = MetaClass.this.getProtectedRole(f);
                }

                public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException {
                    if (this.role != null && !req.isUserInRole(this.role)) {
                        throw new IllegalAccessException("Needs to be in role " + this.role);
                    }
                    if (3.traceable()) {
                        3.traceEval(req, rsp, node, f.getName());
                    }
                    req.getStapler().invoke(req, rsp, f.get(node));
                }

                public String toString() {
                    return String.format("%1$s.%2$s for url=/%2$s/...", f.getDeclaringClass().getName(), f.getName());
                }
            });
        }
        FunctionList getMethods = node.methods.prefix("get");
        for (final Function f : getMethods.signature(new Class[0])) {
            if (f.getName().length() <= 3) continue;
            WebMethod a = f.getAnnotation(WebMethod.class);
            String[] names = a != null && a.name().length > 0 ? a.name() : new String[]{MetaClass.camelize(f.getName().substring(3))};
            for (String name3 : names) {
                this.dispatchers.add(new NameBasedDispatcher(name3){

                    public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                        if (4.traceable()) {
                            4.traceEval(req, rsp, node, f.getName() + "()");
                        }
                        req.getStapler().invoke(req, rsp, f.invoke(req, node, new Object[0]));
                    }

                    public String toString() {
                        return String.format("%1$s() for url=/%2$s/...", f.getQualifiedName(), this.name);
                    }
                });
            }
        }
        for (final Function f : getMethods.signature(StaplerRequest.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name){

                public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (5.traceable()) {
                        5.traceEval(req, rsp, node, f.getName() + "(...)");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, req));
                }

                public String toString() {
                    return String.format("%1$s(StaplerRequest) for url=/%2$s/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(String.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    String token = req.tokens.next();
                    if (6.traceable()) {
                        6.traceEval(req, rsp, node, f.getName() + "(\"" + token + "\")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, token));
                }

                public String toString() {
                    return String.format("%1$s(String) for url=/%2$s/TOKEN/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(Integer.TYPE)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                public void doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    int idx = req.tokens.nextAsInt();
                    if (7.traceable()) {
                        7.traceEval(req, rsp, node, f.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, idx));
                }

                public String toString() {
                    return String.format("%1$s(int) for url=/%2$s/N/...", f.getQualifiedName(), this.name);
                }
            });
        }
        if (node.clazz.isArray()) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (8.traceable()) {
                            8.traceEval(req, rsp, node, "((Object[])", ")[" + index + "]");
                        }
                        req.getStapler().invoke(req, rsp, ((Object[])node)[index]);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                public String toString() {
                    return "Array look-up for url=/N/...";
                }
            });
        }
        if (List.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (9.traceable()) {
                            9.traceEval(req, rsp, node, "((List)", ").get(" + index + ")");
                        }
                        req.getStapler().invoke(req, rsp, ((List)node).get(index));
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                public String toString() {
                    return "List.get(int) look-up for url=/N/...";
                }
            });
        }
        if (Map.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        Object item;
                        String key = req.tokens.peek();
                        if (10.traceable()) {
                            10.traceEval(req, rsp, "((Map)", ").get(\"" + key + "\")");
                        }
                        if ((item = ((Map)node).get(key)) != null) {
                            req.tokens.next();
                            req.getStapler().invoke(req, rsp, item);
                            return true;
                        }
                        if (10.traceable()) {
                            10.trace(req, rsp, "Map.get(\"" + key + "\")==null. Back tracking.");
                        }
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                public String toString() {
                    return "Map.get(String) look-up for url=/TOKEN/...";
                }
            });
        }
        for (final Function f : node.methods.signature(StaplerRequest.class, StaplerResponse.class).name("doDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException {
                    if (11.traceable()) {
                        11.trace(req, rsp, "-> <%s>.doDynamic(...)", node);
                    }
                    f.invoke(req, node, req, rsp);
                    return true;
                }

                public String toString() {
                    return String.format("%s(StaplerRequest,StaplerResponse) for any URL", f.getQualifiedName());
                }
            });
        }
        for (final Function f : getMethods.signature(String.class, StaplerRequest.class, StaplerResponse.class).name("getDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, IOException, ServletException {
                    Object target;
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    String token = req.tokens.next();
                    if (12.traceable()) {
                        12.traceEval(req, rsp, node, "getDynamic(\"" + token + "\",...)");
                    }
                    if ((target = f.invoke(req, node, token, req, rsp)) != null) {
                        req.getStapler().invoke(req, rsp, target);
                        return true;
                    }
                    if (12.traceable()) {
                        12.trace(req, rsp, "            %s.getDynamic(\"%s\",...)==null. Back tracking.", node, token);
                    }
                    req.tokens.prev();
                    return false;
                }

                public String toString() {
                    return String.format("%s(String,StaplerRequest,StaplerResponse) for url=/TOKEN/...", f.getQualifiedName());
                }
            });
        }
    }

    private String getProtectedRole(Field f) {
        try {
            LimitedTo a = f.getAnnotation(LimitedTo.class);
            return a != null ? a.value() : null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        try {
            NO_CACHE = Boolean.getBoolean("stapler.jelly.noCache");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

