/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Facet {
    public static final Logger LOGGER = Logger.getLogger(Facet.class.getName());

    public abstract void buildViewDispatchers(MetaClass var1, List<Dispatcher> var2);

    public static List<Facet> discover(ClassLoader cl) {
        return Facet.discoverExtensions(Facet.class, cl);
    }

    public static <T> List<T> discoverExtensions(Class<T> type, ClassLoader cl) {
        ArrayList r = new ArrayList();
        ClassLoaders classLoaders = new ClassLoaders();
        classLoaders.put(cl);
        DiscoverServiceNames dc = new DiscoverServiceNames(classLoaders);
        ResourceNameIterator itr = dc.findResourceNames(type.getName());
        while (itr.hasNext()) {
            Class<?> c;
            String name = itr.nextResourceName();
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + name, e);
                continue;
            }
            try {
                r.add(c.newInstance());
            }
            catch (InstantiationException e) {
                LOGGER.log(Level.WARNING, "Failed to instanticate " + c, e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to instanticate " + c, e);
            }
        }
        return r;
    }

    public abstract RequestDispatcher createRequestDispatcher(RequestImpl var1, Class var2, Object var3, String var4) throws IOException;

    public abstract boolean handleIndexRequest(RequestImpl var1, ResponseImpl var2, Object var3, MetaClass var4) throws IOException, ServletException;
}

