/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class Dispatcher {
    public static boolean TRACE = Boolean.getBoolean("stapler.trace");
    private static final Logger LOGGER = Logger.getLogger(Dispatcher.class.getName());

    public abstract boolean dispatch(RequestImpl var1, ResponseImpl var2, Object var3) throws IOException, ServletException, IllegalAccessException, InvocationTargetException;

    public abstract String toString();

    public static boolean traceable() {
        return TRACE || LOGGER.isLoggable(Level.FINE);
    }

    public static void traceEval(StaplerRequest req, StaplerResponse rsp, Object node) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(%s%s,\"%s\")", node == null ? "null" : '<' + node.toString() + '>', node == null ? "" : " :" + node.getClass().getName(), ((RequestImpl)req).tokens.assembleRestOfPath()));
    }

    public static void traceEval(StaplerRequest req, StaplerResponse rsp, Object node, String prefix, String suffix) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(%s<%s>%s,\"%s\")", prefix, node, suffix, ((RequestImpl)req).tokens.assembleRestOfPath()));
    }

    public static void traceEval(StaplerRequest req, StaplerResponse rsp, Object node, String expression) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(<%s>.%s,\"%s\")", node, expression, ((RequestImpl)req).tokens.assembleRestOfPath()));
    }

    public static void trace(StaplerRequest req, StaplerResponse rsp, String msg, Object ... args) {
        Dispatcher.trace(req, rsp, String.format(msg, args));
    }

    public static void trace(StaplerRequest req, StaplerResponse rsp, String msg) {
        if (TRACE) {
            EvaluationTrace.get(req).trace(rsp, msg);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }
}

