/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;

final class ClassDescriptor {
    public final Class clazz;
    public final FunctionList methods;
    public final Field[] fields;

    public ClassDescriptor(Class clazz, Class ... wrappers) {
        this.clazz = clazz;
        this.fields = clazz.getFields();
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Method method : clazz.getMethods()) {
            functions.add(new Function.InstanceFunction(method).protectBy(method));
        }
        if (wrappers != null) {
            for (GenericDeclaration genericDeclaration : wrappers) {
                for (Method m : ((Class)genericDeclaration).getMethods()) {
                    Class<?>[] p;
                    if (!Modifier.isStatic(m.getModifiers()) || (p = m.getParameterTypes()).length == 0 || p[0].isAssignableFrom(clazz)) continue;
                    functions.add(new Function.StaticFunction(m).protectBy(m));
                }
            }
        }
        this.methods = new FunctionList(functions);
    }
}

