/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AncestorImpl
implements Ancestor {
    private final List<AncestorImpl> owner;
    private final int listIndex;
    private Object object;
    private String[] tokens;
    private int index;
    private String contextPath;

    public AncestorImpl(List<AncestorImpl> owner) {
        this.owner = owner;
        this.listIndex = owner.size();
        owner.add(this);
    }

    public void set(Object object, RequestImpl req) {
        this.object = object;
        this.tokens = req.tokens.tokens;
        this.index = req.tokens.idx;
        this.contextPath = req.getContextPath();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(this.contextPath);
        for (int i = 0; i < this.index; ++i) {
            buf.append('/');
            buf.append(this.tokens[i]);
        }
        try {
            return new URI(null, buf.toString(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(e);
            throw y;
        }
    }

    @Override
    public String getFullUrl() {
        StringBuilder buf = new StringBuilder();
        StaplerRequest req = Stapler.getCurrentRequest();
        buf.append(req.getScheme());
        buf.append("://");
        buf.append(req.getServerName());
        if (req.getServerPort() != 80) {
            buf.append(':').append(req.getServerPort());
        }
        buf.append(this.getUrl());
        return buf.toString();
    }

    @Override
    public String getRelativePath() {
        StringBuilder buf = new StringBuilder();
        for (int i = this.index; i < this.tokens.length; ++i) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append("..");
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    @Override
    public Ancestor getPrev() {
        if (this.listIndex == 0) {
            return null;
        }
        return this.owner.get(this.listIndex - 1);
    }

    @Override
    public Ancestor getNext() {
        if (this.listIndex == this.owner.size() - 1) {
            return null;
        }
        return this.owner.get(this.listIndex + 1);
    }

    public String toString() {
        return this.object.toString();
    }
}

