/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.maven;

import com.sun.wts.tools.maven.SubversionWagon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.repository.Repository;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;

public class JavaNetWagon
extends SubversionWagon {
    private Properties props;

    protected String getSubversionURL() {
        Repository r = this.getRepository();
        String url = r.getUrl();
        url = url.substring(9);
        return "https://svn.java.net/svn" + url;
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        try {
            this.doOpenConnection();
        }
        catch (SVNCancelException e) {
            if (this.getDotJavaNetFile().exists()) {
                throw new ConnectionException("Unable to connect to " + this.getSubversionURL(), (Throwable)e);
            }
            throw new ConnectionException("Unable to connect to " + this.getSubversionURL() + " You need to create " + this.getDotJavaNetFile() + " See https://javanettasks.dev.java.net/nonav/maven/config.html", (Throwable)e);
        }
        catch (SVNException e) {
            throw new ConnectionException("Unable to connect to " + this.getSubversionURL(), (Throwable)e);
        }
    }

    protected ISVNProxyManager getProxyManager(SVNURL url) {
        Properties properties = this.loadProperties();
        if (properties != null) {
            final String proxyServer = properties.getProperty("proxyServer");
            final String proxyPort = properties.getProperty("proxyPort");
            if (proxyServer != null) {
                StringBuilder debugMessage = new StringBuilder("proxyServer = " + proxyServer);
                debugMessage.append(proxyPort == null ? "" : ", proxyPort = " + proxyPort);
                this.fireTransferDebug(debugMessage.toString());
                return new ISVNProxyManager(){

                    public String getProxyHost() {
                        return proxyServer;
                    }

                    public int getProxyPort() {
                        if (proxyPort != null) {
                            return Integer.valueOf(proxyPort);
                        }
                        return 8080;
                    }

                    public String getProxyUserName() {
                        return null;
                    }

                    public String getProxyPassword() {
                        return null;
                    }

                    public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
                    }
                };
            }
        }
        return super.getProxyManager(url);
    }

    protected ISVNAuthenticationProvider createAuthenticationProvider() {
        return new ISVNAuthenticationProvider(){

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                if (previousAuth != null) {
                    JavaNetWagon.this.fireTransferDebug("Subversion authentication failed:" + url);
                    return null;
                }
                Properties props = JavaNetWagon.this.loadProperties();
                if (props != null) {
                    return new SVNPasswordAuthentication(props.getProperty("userName"), props.getProperty("password"), false);
                }
                AuthenticationInfo auth = JavaNetWagon.this.getAuthenticationInfo();
                if (auth != null && auth.getPassword() != null) {
                    return new SVNPasswordAuthentication(auth.getUserName(), auth.getPassword(), false);
                }
                return null;
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 1;
            }
        };
    }

    protected Properties loadProperties() {
        if (this.props != null) {
            return this.props;
        }
        File prop = this.getDotJavaNetFile();
        if (prop.exists()) {
            this.fireTransferDebug("Using " + prop);
            this.props = new Properties();
            try {
                this.props.load(new FileInputStream(prop));
                return this.props;
            }
            catch (IOException e) {
                this.fireTransferDebug("Failed to load " + prop);
                e.printStackTrace();
                return null;
            }
        }
        this.fireTransferDebug(prop + " didn't exist");
        return null;
    }

    private File getDotJavaNetFile() {
        return new File(new File(System.getProperty("user.home")), ".java.net");
    }
}

