/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Paths.java\t1.29 07/05/05")
public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private Log log;
    private Options options;
    private Lint lint;
    private boolean warn;
    private Map<JavaFileManager.Location, Path> pathsForLocation;
    private boolean inited = false;
    private File bootClassPathRtJar = null;
    private Path sourceSearchPath;
    private Path classSearchPath;
    private Path otherSearchPath;

    public static Paths instance(Context context) {
        Paths instance = context.get(pathsKey);
        if (instance == null) {
            instance = new Paths(context);
        }
        return instance;
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.pathsForLocation = new HashMap<JavaFileManager.Location, Path>(16);
        this.setContext(context);
    }

    void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.lint = Lint.instance(context);
    }

    Path getPathForLocation(JavaFileManager.Location location) {
        Path path = this.pathsForLocation.get(location);
        if (path == null) {
            this.setPathForLocation(location, null);
        }
        return this.pathsForLocation.get(location);
    }

    void setPathForLocation(JavaFileManager.Location location, Iterable<? extends File> path) {
        Path p;
        if (path == null) {
            p = location == StandardLocation.CLASS_PATH ? this.computeUserClassPath() : (location == StandardLocation.PLATFORM_CLASS_PATH ? this.computeBootClassPath() : (location == StandardLocation.ANNOTATION_PROCESSOR_PATH ? this.computeAnnotationProcessorPath() : (location == StandardLocation.SOURCE_PATH ? this.computeSourcePath() : null)));
        } else {
            p = new Path();
            for (File file : path) {
                p.addFile(file, this.warn);
            }
        }
        this.pathsForLocation.put(location, p);
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.lint.isEnabled(Lint.LintCategory.PATH);
            this.pathsForLocation.put(StandardLocation.PLATFORM_CLASS_PATH, this.computeBootClassPath());
            this.pathsForLocation.put(StandardLocation.CLASS_PATH, this.computeUserClassPath());
            this.pathsForLocation.put(StandardLocation.SOURCE_PATH, this.computeSourcePath());
            this.inited = true;
        }
    }

    public Collection<File> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH));
    }

    public Collection<File> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.CLASS_PATH));
    }

    public Collection<File> sourcePath() {
        this.lazy();
        Path p = this.getPathForLocation(StandardLocation.SOURCE_PATH);
        return p == null || p.size() == 0 ? null : Collections.unmodifiableCollection(p);
    }

    boolean isBootClassPathRtJar(File file) {
        return file.equals(this.bootClassPathRtJar);
    }

    private Path computeBootClassPath() {
        this.bootClassPathRtJar = null;
        Path path = new Path();
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_PREPEND));
        String optionValue = this.options.get(OptionName.ENDORSEDDIRS);
        if (optionValue != null) {
            path.addDirectories(optionValue);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        optionValue = this.options.get(OptionName.BOOTCLASSPATH);
        if (optionValue != null) {
            path.addFiles(optionValue);
        } else {
            String files = System.getProperty("sun.boot.class.path");
            path.addFiles(files, false);
            File rt_jar = new File("rt.jar");
            for (String file : new PathIterator(files, null)) {
                File f = new File(file);
                if (!new File(f.getName()).equals(rt_jar)) continue;
                this.bootClassPathRtJar = f;
            }
        }
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_APPEND));
        optionValue = this.options.get(OptionName.EXTDIRS);
        if (optionValue != null) {
            path.addDirectories(optionValue);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        return path;
    }

    private Path computeUserClassPath() {
        String cp = this.options.get(OptionName.CLASSPATH);
        if (cp == null) {
            cp = System.getProperty("env.class.path");
        }
        if (cp == null && System.getProperty("application.home") == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null) {
            cp = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(".").addFiles(cp);
    }

    private Path computeSourcePath() {
        String sourcePathArg = this.options.get(OptionName.SOURCEPATH);
        if (sourcePathArg == null) {
            return null;
        }
        return new Path().addFiles(sourcePathArg);
    }

    private Path computeAnnotationProcessorPath() {
        String processorPathArg = this.options.get(OptionName.PROCESSORPATH);
        if (processorPathArg == null) {
            return null;
        }
        return new Path().addFiles(processorPathArg);
    }

    public Collection<File> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            Path sourcePath = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.sourceSearchPath = sourcePath != null ? sourcePath : userClassPath;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<File> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            Path bootClassPath = this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(bootClassPath);
            this.classSearchPath.addAll(userClassPath);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    Collection<File> otherSearchPath() {
        if (this.otherSearchPath == null) {
            this.lazy();
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            Path sourcePath = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            if (sourcePath == null) {
                this.otherSearchPath = userClassPath;
            } else {
                this.otherSearchPath = new Path();
                this.otherSearchPath.addAll(userClassPath);
                this.otherSearchPath.addAll(sourcePath);
            }
        }
        return Collections.unmodifiableCollection(this.otherSearchPath);
    }

    private static boolean isArchive(File file) {
        String n = file.getName().toLowerCase();
        return file.isFile() && (n.endsWith(".jar") || n.endsWith(".zip"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private Set<File> canonicalValues = new HashSet<File>();
        private String emptyPathDefault = null;

        public Path expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public Path emptyPathDefault(String x) {
            this.emptyPathDefault = x;
            return this;
        }

        public Path addDirectories(String dirs, boolean warn) {
            if (dirs != null) {
                for (String dir : new PathIterator(dirs)) {
                    this.addDirectory(dir, warn);
                }
            }
            return this;
        }

        public Path addDirectories(String dirs) {
            return this.addDirectories(dirs, Paths.this.warn);
        }

        private void addDirectory(String dir, boolean warn) {
            if (!new File(dir).isDirectory()) {
                if (warn) {
                    Paths.this.log.warning("dir.path.element.not.found", dir);
                }
                return;
            }
            File[] files = new File(dir).listFiles();
            if (files == null) {
                return;
            }
            for (File direntry : files) {
                if (!Paths.isArchive(direntry)) continue;
                this.addFile(direntry, warn);
            }
        }

        public Path addFiles(String files, boolean warn) {
            if (files != null) {
                for (String file : new PathIterator(files, this.emptyPathDefault)) {
                    this.addFile(file, warn);
                }
            }
            return this;
        }

        public Path addFiles(String files) {
            return this.addFiles(files, Paths.this.warn);
        }

        public Path addFile(String file, boolean warn) {
            this.addFile(new File(file), warn);
            return this;
        }

        public void addFile(File file, boolean warn) {
            File canonFile;
            try {
                canonFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                canonFile = file;
            }
            if (this.contains(file) || this.canonicalValues.contains(canonFile)) {
                return;
            }
            if (!file.exists()) {
                if (warn) {
                    Paths.this.log.warning("path.element.not.found", file);
                }
            } else if (file.isFile() && !Paths.isArchive(file)) {
                try {
                    ZipFile z = new ZipFile(file);
                    z.close();
                    if (warn) {
                        Paths.this.log.warning("unexpected.archive.file", file);
                    }
                }
                catch (IOException e) {
                    if (warn) {
                        Paths.this.log.warning("invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(canonFile);
            if (this.expandJarClassPaths && file.exists() && file.isFile()) {
                this.addJarClassPath(file, warn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addJarClassPath(File jarFile, boolean warn) {
            try {
                JarFile jar;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                String jarParent = jarFile.getParent();
                                jar = new JarFile(jarFile);
                                try {
                                    Manifest man = jar.getManifest();
                                    if (man == null) {
                                        Object var12_7 = null;
                                        break block8;
                                    }
                                    Attributes attr = man.getMainAttributes();
                                    if (attr == null) {
                                        break block9;
                                    }
                                    String path = attr.getValue(Attributes.Name.CLASS_PATH);
                                    if (path == null) {
                                        break block10;
                                    }
                                    StringTokenizer st = new StringTokenizer(path);
                                    while (st.hasMoreTokens()) {
                                        String elt = st.nextToken();
                                        File f = jarParent == null ? new File(elt) : new File(jarParent, elt);
                                        this.addFile(f, warn);
                                    }
                                    break block11;
                                }
                                catch (Throwable throwable) {
                                    Object var12_11 = null;
                                    jar.close();
                                    throw throwable;
                                }
                            }
                            jar.close();
                            return;
                        }
                        Object var12_8 = null;
                        jar.close();
                        return;
                    }
                    Object var12_9 = null;
                    jar.close();
                    return;
                }
                Object var12_10 = null;
                jar.close();
                return;
            }
            catch (IOException e) {
                Paths.this.log.error("error.reading.file", jarFile, e.getLocalizedMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathIterator
    implements Iterable<String> {
        private int pos = 0;
        private final String path;
        private final String emptyPathDefault;

        public PathIterator(String path, String emptyPathDefault) {
            this.path = path;
            this.emptyPathDefault = emptyPathDefault;
        }

        public PathIterator(String path) {
            this(path, null);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return PathIterator.this.pos <= PathIterator.this.path.length();
                }

                @Override
                public String next() {
                    int beg = PathIterator.this.pos;
                    int end = PathIterator.this.path.indexOf(File.pathSeparator, beg);
                    if (end == -1) {
                        end = PathIterator.this.path.length();
                    }
                    PathIterator.this.pos = end + 1;
                    if (beg == end && PathIterator.this.emptyPathDefault != null) {
                        return PathIterator.this.emptyPathDefault;
                    }
                    return PathIterator.this.path.substring(beg, end);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

