/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.processing.ServiceProxy;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Paths;
import com.sun.tools.javac.util.Version;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JavacProcessingEnvironment.java\t1.34 07/05/05")
public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean lint;
    private final boolean procOnly;
    private final boolean fatalErrors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private DiscoveredProcessors discoveredProcs;
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    Log log;
    Source source;
    private Context context;
    private static TreeScanner treeCleaner = new TreeScanner(){

        public void scan(JCTree node) {
            super.scan(node);
            if (node != null) {
                node.type = null;
            }
        }

        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            node.packge = null;
            super.visitTopLevel(node);
        }

        public void visitClassDef(JCTree.JCClassDecl node) {
            node.sym = null;
            super.visitClassDef(node);
        }

        public void visitMethodDef(JCTree.JCMethodDecl node) {
            node.sym = null;
            super.visitMethodDef(node);
        }

        public void visitVarDef(JCTree.JCVariableDecl node) {
            node.sym = null;
            super.visitVarDef(node);
        }

        public void visitNewClass(JCTree.JCNewClass node) {
            node.constructor = null;
            super.visitNewClass(node);
        }

        public void visitAssignop(JCTree.JCAssignOp node) {
            node.operator = null;
            super.visitAssignop(node);
        }

        public void visitUnary(JCTree.JCUnary node) {
            node.operator = null;
            super.visitUnary(node);
        }

        public void visitBinary(JCTree.JCBinary node) {
            node.operator = null;
            super.visitBinary(node);
        }

        public void visitSelect(JCTree.JCFieldAccess node) {
            node.sym = null;
            super.visitSelect(node);
        }

        public void visitIdent(JCTree.JCIdent node) {
            node.sym = null;
            super.visitIdent(node);
        }
    };
    private static final Pattern allMatches = Pattern.compile(".*");
    private static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public JavacProcessingEnvironment(Context context, Iterable<? extends Processor> processors) {
        this.options = Options.instance(context);
        this.context = context;
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.printProcessorInfo = this.options.get("-XprintProcessorInfo") != null;
        this.printRounds = this.options.get("-XprintRounds") != null;
        this.verbose = this.options.get("-verbose") != null;
        this.lint = this.options.lint("processing");
        this.procOnly = this.options.get("-proc:only") != null || this.options.get("-Xprint") != null;
        this.fatalErrors = this.options.get("fatalEnterError") != null;
        this.platformAnnotations = this.initPlatformAnnotations();
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = new JavacElements(context);
        this.typeUtils = new JavacTypes(context);
        this.processorOptions = this.initProcessorOptions(context);
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.initProcessorIterator(context, processors);
    }

    private Set<String> initPlatformAnnotations() {
        HashSet<String> platformAnnotations = new HashSet<String>();
        platformAnnotations.add("java.lang.Deprecated");
        platformAnnotations.add("java.lang.Override");
        platformAnnotations.add("java.lang.SuppressWarnings");
        platformAnnotations.add("java.lang.annotation.Documented");
        platformAnnotations.add("java.lang.annotation.Inherited");
        platformAnnotations.add("java.lang.annotation.Retention");
        platformAnnotations.add("java.lang.annotation.Target");
        return Collections.unmodifiableSet(platformAnnotations);
    }

    private void initProcessorIterator(Context context, Iterable<? extends Processor> processors) {
        Iterator processorIterator;
        Paths paths = Paths.instance(context);
        Log log = Log.instance(context);
        if (this.options.get("-Xprint") != null) {
            try {
                Processor processor = (Processor)PrintingProcessor.class.newInstance();
                processorIterator = List.of(processor).iterator();
            }
            catch (Throwable t) {
                AssertionError assertError = new AssertionError((Object)"Problem instantiating PrintingProcessor.");
                ((Throwable)((Object)assertError)).initCause(t);
                throw assertError;
            }
        }
        if (processors != null) {
            processorIterator = processors.iterator();
        } else {
            String processorNames = this.options.get("-processor");
            JavaFileManager fileManager = context.get(JavaFileManager.class);
            try {
                Iterator it;
                ClassLoader processorCL;
                ClassLoader classLoader = processorCL = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : fileManager.getClassLoader(StandardLocation.CLASS_PATH);
                processorIterator = processorNames != null ? new NameProcessIterator(processorNames, processorCL, log) : (it = Service.providers(Processor.class, (ClassLoader)processorCL));
            }
            catch (SecurityException e) {
                if (fileManager instanceof JavacFileManager) {
                    Iterable<? extends File> workingPath;
                    JavacFileManager standardFileManager = (JavacFileManager)fileManager;
                    Iterable<? extends File> iterable = workingPath = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? standardFileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) : standardFileManager.getLocation(StandardLocation.CLASS_PATH);
                    if (this.needClassLoader(processorNames, workingPath)) {
                        log.error("proc.cant.create.loader", e.getLocalizedMessage());
                        throw new Abort(e);
                    }
                } else {
                    log.error("proc.cant.create.loader", e.getLocalizedMessage());
                    throw new Abort(e);
                }
                processorIterator = new LinkedList().iterator();
            }
        }
        this.discoveredProcs = new DiscoveredProcessors(processorIterator);
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions(Context context) {
        Options options = Options.instance(context);
        Set<String> keySet = options.keySet();
        LinkedHashMap<String, String> tempOptions = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            if (!key.startsWith("-A") || key.length() <= 2) continue;
            int sepIndex = key.indexOf(61);
            String candidateKey = null;
            String candidateValue = null;
            if (sepIndex == -1) {
                candidateKey = key.substring(2);
            } else if (sepIndex >= 3) {
                candidateKey = key.substring(2, sepIndex);
                candidateValue = sepIndex < key.length() - 1 ? key.substring(sepIndex + 1) : null;
            }
            tempOptions.put(candidateKey, candidateValue);
        }
        return Collections.unmodifiableMap(tempOptions);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> unmatchedProcessorOptions = new HashSet<String>();
        unmatchedProcessorOptions.addAll(this.processorOptions.keySet());
        return unmatchedProcessorOptions;
    }

    private void discoverAndRunProcs(Context context, Set<TypeElement> annotationsPresent, List<Symbol.ClassSymbol> topLevelClasses, List<Symbol.PackageSymbol> packageInfoFiles) {
        PrintWriter xout = context.get(Log.outKey);
        HashMap<String, TypeElement> unmatchedAnnotations = new HashMap<String, TypeElement>(annotationsPresent.size());
        for (TypeElement a : annotationsPresent) {
            unmatchedAnnotations.put(a.getQualifiedName().toString(), a);
        }
        if (unmatchedAnnotations.size() == 0) {
            unmatchedAnnotations.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator psi = this.discoveredProcs.iterator();
        Set<Symbol.TypeSymbol> rootElements = new LinkedHashSet<Symbol.TypeSymbol>();
        rootElements.addAll(topLevelClasses);
        rootElements.addAll(packageInfoFiles);
        rootElements = Collections.unmodifiableSet(rootElements);
        JavacRoundEnvironment renv = new JavacRoundEnvironment(false, false, rootElements, this);
        while (unmatchedAnnotations.size() > 0 && psi.hasNext()) {
            ProcessorState ps = psi.next();
            HashSet<String> matchedNames = new HashSet<String>();
            LinkedHashSet<TypeElement> typeElements = new LinkedHashSet<TypeElement>();
            for (String unmatchedAnnotationName : unmatchedAnnotations.keySet()) {
                if (!ps.annotationSupported(unmatchedAnnotationName)) continue;
                matchedNames.add(unmatchedAnnotationName);
                TypeElement te = (TypeElement)unmatchedAnnotations.get(unmatchedAnnotationName);
                if (te == null) continue;
                typeElements.add(te);
            }
            if (matchedNames.size() <= 0 && !ps.contributed) continue;
            boolean processingResult = this.callProcessor(ps.processor, typeElements, renv);
            ps.contributed = true;
            ps.removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                xout.println(Log.getLocalizedString("x.print.processor.info", ps.processor.getClass().getName(), ((Object)matchedNames).toString(), processingResult));
            }
            if (!processingResult) continue;
            unmatchedAnnotations.keySet().removeAll(matchedNames);
        }
        unmatchedAnnotations.remove("");
        if (this.lint && unmatchedAnnotations.size() > 0) {
            unmatchedAnnotations.keySet().removeAll(this.platformAnnotations);
            if (unmatchedAnnotations.size() > 0) {
                this.log = Log.instance(context);
                this.log.warning("proc.annotations.without.processors", unmatchedAnnotations.keySet());
            }
        }
        psi.runContributingProcs(renv);
        if (this.options.get("displayFilerState") != null) {
            this.filer.displayState();
        }
    }

    private boolean callProcessor(Processor proc, Set<? extends TypeElement> tes, RoundEnvironment renv) {
        try {
            return proc.process(tes, renv);
        }
        catch (Symbol.CompletionFailure ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            this.log.error("proc.cant.access", ex.sym, ex.errmsg, out.toString());
            return false;
        }
        catch (Throwable t) {
            throw new AnnotationProcessingError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCompiler doProcessing(Context context, List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Iterable<? extends Symbol.PackageSymbol> pckSymbols) throws IOException {
        this.log = Log.instance(context);
        PrintWriter xout = context.get(Log.outKey);
        TaskListener taskListener = context.get(TaskListener.class);
        AnnotationCollector collector = new AnnotationCollector();
        JavaCompiler compiler = JavaCompiler.instance(context);
        compiler.todo.clear();
        boolean round = false;
        List<Symbol.ClassSymbol> topLevelClasses = this.getTopLevelClasses(roots);
        for (Symbol.ClassSymbol classSym : classSymbols) {
            topLevelClasses = topLevelClasses.prepend(classSym);
        }
        List<Symbol.PackageSymbol> packageInfoFiles = this.getPackageInfoFiles(roots);
        LinkedHashSet<Symbol.PackageSymbol> specifiedPackages = new LinkedHashSet<Symbol.PackageSymbol>();
        for (Symbol.PackageSymbol packageSymbol : pckSymbols) {
            specifiedPackages.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(specifiedPackages);
        LinkedHashSet<TypeElement> annotationsPresent = new LinkedHashSet<TypeElement>();
        ComputeAnnotationSet computeAnnotationSet = new ComputeAnnotationSet(this.elementUtils);
        for (Symbol.ClassSymbol classSym : topLevelClasses) {
            computeAnnotationSet.scan((Element)classSym, (Set<TypeElement>)annotationsPresent);
        }
        for (Symbol.PackageSymbol pkgSym : packageInfoFiles) {
            computeAnnotationSet.scan((Element)pkgSym, (Set<TypeElement>)annotationsPresent);
        }
        Context currentContext = context;
        int roundNumber = 0;
        boolean errorStatus = false;
        while (true) {
            Object var19_22;
            if (this.fatalErrors && compiler.errorCount() != 0) {
                errorStatus = true;
                break;
            }
            this.context = currentContext;
            this.printRoundInfo(xout, ++roundNumber, topLevelClasses, annotationsPresent, false);
            if (taskListener != null) {
                taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                this.discoverAndRunProcs(currentContext, annotationsPresent, topLevelClasses, packageInfoFiles);
                var19_22 = null;
                if (taskListener != null) {
                    taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
            catch (Throwable throwable) {
                var19_22 = null;
                if (taskListener != null) {
                    taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
                throw throwable;
            }
            if (this.messager.errorRaised()) {
                errorStatus = true;
                break;
            }
            if (!this.moreToDo()) break;
            annotationsPresent = new LinkedHashSet();
            topLevelClasses = List.nil();
            packageInfoFiles = List.nil();
            compiler.close();
            currentContext = this.contextForNextRound(currentContext, true);
            JavaFileManager fileManager = currentContext.get(JavaFileManager.class);
            List<JavaFileObject> fileObjects = List.nil();
            for (JavaFileObject jfo : this.filer.getGeneratedSourceFileObjects()) {
                fileObjects = fileObjects.prepend(jfo);
            }
            compiler = JavaCompiler.instance(currentContext);
            List<JCTree.JCCompilationUnit> parsedFiles = compiler.parseFiles(fileObjects);
            roots = JavacProcessingEnvironment.cleanTrees(roots).reverse();
            for (JCTree.JCCompilationUnit unit : parsedFiles) {
                roots = roots.prepend(unit);
            }
            roots = roots.reverse();
            if (compiler.parseErrors()) {
                errorStatus = true;
                break;
            }
            ListBuffer<Symbol.ClassSymbol> classes = this.enterNewClassFiles(currentContext);
            compiler.enterTrees(roots);
            classes.appendList(this.getTopLevelClasses(parsedFiles));
            topLevelClasses = classes.toList();
            packageInfoFiles = this.getPackageInfoFiles(parsedFiles);
            annotationsPresent = new LinkedHashSet();
            for (Symbol.ClassSymbol classSym : topLevelClasses) {
                computeAnnotationSet.scan((Element)classSym, (Set<TypeElement>)annotationsPresent);
            }
            for (Symbol.PackageSymbol pkgSym : packageInfoFiles) {
                computeAnnotationSet.scan((Element)pkgSym, (Set<TypeElement>)annotationsPresent);
            }
            this.updateProcessingState(currentContext, false);
        }
        this.runLastRound(xout, roundNumber, errorStatus, taskListener);
        compiler.close();
        currentContext = this.contextForNextRound(currentContext, true);
        compiler = JavaCompiler.instance(currentContext);
        this.filer.newRound(currentContext, true);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        errorStatus = errorStatus || this.messager.errorRaised();
        this.close();
        if (taskListener != null) {
            taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        if (errorStatus) {
            compiler.log.nerrors += this.messager.errorCount();
            if (compiler.errorCount() == 0) {
                ++compiler.log.nerrors;
            }
        } else if (this.procOnly) {
            compiler.todo.clear();
        } else {
            compiler.close();
            currentContext = this.contextForNextRound(currentContext, true);
            compiler = JavaCompiler.instance(currentContext);
            compiler.enterTrees(JavacProcessingEnvironment.cleanTrees(roots));
        }
        return compiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLastRound(PrintWriter xout, int roundNumber, boolean errorStatus, TaskListener taskListener) throws IOException {
        List<Symbol.ClassSymbol> noTopLevelClasses = List.nil();
        Set<TypeElement> noAnnotations = Collections.emptySet();
        this.printRoundInfo(xout, ++roundNumber, noTopLevelClasses, noAnnotations, true);
        Set emptyRootElements = Collections.emptySet();
        JavacRoundEnvironment renv = new JavacRoundEnvironment(true, errorStatus, emptyRootElements, this);
        if (taskListener != null) {
            taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
        }
        try {
            this.discoveredProcs.iterator().runContributingProcs(renv);
            Object var10_9 = null;
            if (taskListener != null) {
                taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (taskListener != null) {
                taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            throw throwable;
        }
    }

    private void updateProcessingState(Context currentContext, boolean lastRound) {
        this.filer.newRound(currentContext, lastRound);
        this.messager.newRound(currentContext);
        this.elementUtils.setContext(currentContext);
        this.typeUtils.setContext(currentContext);
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning("proc.unmatched.processor.options", this.unmatchedProcessorOptions.toString());
        }
    }

    private void printRoundInfo(PrintWriter xout, int roundNumber, List<Symbol.ClassSymbol> topLevelClasses, Set<TypeElement> annotationsPresent, boolean lastRound) {
        if (this.printRounds || this.verbose) {
            xout.println(Log.getLocalizedString("x.print.rounds", roundNumber, "{" + topLevelClasses.toString(", ") + "}", annotationsPresent, lastRound));
        }
    }

    private ListBuffer<Symbol.ClassSymbol> enterNewClassFiles(Context currentContext) {
        ClassReader reader = ClassReader.instance(currentContext);
        Name.Table names = Name.Table.instance(currentContext);
        ListBuffer<Symbol.ClassSymbol> list = new ListBuffer<Symbol.ClassSymbol>();
        for (Map.Entry<String, JavaFileObject> entry : this.filer.getGeneratedClasses().entrySet()) {
            Name name = names.fromString(entry.getKey());
            JavaFileObject file = entry.getValue();
            if (file.getKind() != JavaFileObject.Kind.CLASS) {
                throw new AssertionError(file);
            }
            Symbol.ClassSymbol cs = reader.enterClass(name, file);
            list.append(cs);
        }
        return list;
    }

    @Override
    public void close() {
        this.filer.close();
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            for (JCTree node : jCCompilationUnit.defs) {
                if (node.tag != 3) continue;
                classes = classes.prepend(((JCTree.JCClassDecl)node).sym);
            }
        }
        return classes.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            boolean isPkgInfo = jCCompilationUnit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (!isPkgInfo) continue;
            packages = packages.prepend(jCCompilationUnit.packge);
        }
        return packages.reverse();
    }

    private Context contextForNextRound(Context context, boolean shareNames) throws IOException {
        TaskListener tl;
        DiagnosticListener dl;
        Context next = new Context();
        Options options = Options.instance(context);
        assert (options != null);
        next.put(Options.optionsKey, options);
        PrintWriter out = context.get(Log.outKey);
        assert (out != null);
        next.put(Log.outKey, out);
        if (shareNames) {
            Name.Table names = Name.Table.instance(context);
            assert (names != null);
            next.put(Name.Table.namesKey, names);
        }
        if ((dl = context.get(DiagnosticListener.class)) != null) {
            next.put(DiagnosticListener.class, dl);
        }
        if ((tl = context.get(TaskListener.class)) != null) {
            next.put(TaskListener.class, tl);
        }
        JavaFileManager jfm = context.get(JavaFileManager.class);
        assert (jfm != null);
        next.put(JavaFileManager.class, jfm);
        if (jfm instanceof JavacFileManager) {
            ((JavacFileManager)jfm).setContext(next);
        }
        Name.Table names = Name.Table.instance(context);
        assert (names != null);
        next.put(Name.Table.namesKey, names);
        Keywords keywords = Keywords.instance(context);
        assert (keywords != null);
        next.put(Keywords.keywordsKey, keywords);
        JavaCompiler oldCompiler = JavaCompiler.instance(context);
        JavaCompiler nextCompiler = JavaCompiler.instance(next);
        nextCompiler.initRound(oldCompiler);
        JavacTaskImpl task = context.get(JavacTaskImpl.class);
        if (task != null) {
            next.put(JavacTaskImpl.class, task);
            task.updateContext(next);
        }
        context.clear();
        return next;
    }

    private boolean needClassLoader(String procNames, Iterable<? extends File> workingpath) {
        if (procNames != null) {
            return true;
        }
        URL[] urls = new URL[1];
        for (File file : workingpath) {
            try {
                urls[0] = file.toURI().toURL();
                if (!ServiceProxy.hasService(Processor.class, urls)) continue;
                return true;
            }
            catch (MalformedURLException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (ServiceProxy.ServiceConfigurationError e) {
                this.log.error("proc.bad.config.file", e.getLocalizedMessage());
                return true;
            }
        }
        return false;
    }

    private static <T extends JCTree> List<T> cleanTrees(List<T> nodes) {
        for (JCTree node : nodes) {
            treeCleaner.scan(node);
        }
        return nodes;
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = JavacProcessingEnvironment.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public static Pattern importStringToPattern(String s, Processor p, Log log) {
        if (s.equals("*")) {
            return allMatches;
        }
        String t = s;
        boolean star = false;
        boolean valid = true;
        int index = t.indexOf(42);
        if (index != -1) {
            if (index == t.length() - 1) {
                if (index - 1 >= 0) {
                    valid = t.charAt(index - 1) == '.';
                    t = t.substring(0, t.length() - 2);
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            String[] javaIds;
            for (String javaId : javaIds = t.split("\\.", t.length() + 2)) {
                valid &= SourceVersion.isIdentifier(javaId);
            }
        }
        if (!valid) {
            log.warning("proc.malformed.supported.string", s, p.getClass().getName());
            return noMatches;
        }
        String s_prime = s.replaceAll("\\.", "\\\\.");
        if (s_prime.endsWith("*")) {
            s_prime = s_prime.substring(0, s_prime.length() - 1) + ".+";
        }
        return Pattern.compile(s_prime);
    }

    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "javac ProcessingEnvironment version @(#)JavacProcessingEnvironment.java\t1.34 07/05/05";
    }

    public static boolean isValidOptionName(String optionName) {
        for (String s : optionName.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationCollector
    extends TreeScanner {
        List<JCTree> path = List.nil();
        static final boolean verbose = false;
        List<JCTree.JCAnnotation> annotations = List.nil();

        private AnnotationCollector() {
        }

        public List<JCTree.JCAnnotation> findAnnotations(List<? extends JCTree> nodes) {
            this.annotations = List.nil();
            this.scan(nodes);
            List<JCTree.JCAnnotation> found = this.annotations;
            this.annotations = List.nil();
            return found.reverse();
        }

        @Override
        public void scan(JCTree node) {
            if (node == null) {
                return;
            }
            Symbol sym = TreeInfo.symbolFor(node);
            if (sym != null) {
                this.path = this.path.prepend(node);
            }
            super.scan(node);
            if (sym != null) {
                this.path = this.path.tail;
            }
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation node) {
            this.annotations = this.annotations.prepend(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComputeAnnotationSet
    extends ElementScanner6<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement e, Set<TypeElement> p) {
            return p;
        }

        @Override
        public Set<TypeElement> scan(Element e, Set<TypeElement> p) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(e)) {
                Element e2 = annotationMirror.getAnnotationType().asElement();
                p.add((TypeElement)e2);
            }
            return (Set)super.scan(e, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> processorIterator) {
            this.processorIterator = processorIterator;
            this.procStateList = new ArrayList();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcInterator;

            ProcessorStateIterator(DiscoveredProcessors psi) {
                this.psi = psi;
                this.innerIter = psi.procStateList.iterator();
                this.onProcInterator = false;
            }

            @Override
            public ProcessorState next() {
                try {
                    if (!this.onProcInterator) {
                        if (this.innerIter.hasNext()) {
                            return this.innerIter.next();
                        }
                        this.onProcInterator = true;
                    }
                    if (this.psi.processorIterator.hasNext()) {
                        ProcessorState ps = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this);
                        this.psi.procStateList.add(ps);
                        return ps;
                    }
                    throw new NoSuchElementException();
                }
                catch (ServiceConfigurationError e) {
                    JavacProcessingEnvironment.this.log.error("proc.bad.config.file", e.getLocalizedMessage());
                    throw new Abort();
                }
                catch (Throwable e) {
                    JavacProcessingEnvironment.this.log.error("proc.processor.constructor.error", e.getLocalizedMessage());
                    throw new Abort();
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.onProcInterator) {
                        return this.psi.processorIterator.hasNext();
                    }
                    return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
                }
                catch (ServiceConfigurationError e) {
                    JavacProcessingEnvironment.this.log.error("proc.bad.config.file", e.getLocalizedMessage());
                    throw new Abort();
                }
                catch (Throwable e) {
                    JavacProcessingEnvironment.this.log.error("proc.processor.constructor.error", e.getLocalizedMessage());
                    throw new Abort();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment re) {
                if (!this.onProcInterator) {
                    Set emptyTypeElements = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState ps = this.innerIter.next();
                        if (!ps.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(ps.processor, emptyTypeElements, re);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private ArrayList<Pattern> supportedAnnotationPatterns;
        private ArrayList<String> supportedOptionNames;

        ProcessorState(Processor p, Log log, Source source, ProcessingEnvironment env) {
            this.processor = p;
            this.contributed = false;
            try {
                this.processor.init(env);
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationPatterns = new ArrayList();
                for (String importString : this.processor.getSupportedAnnotationTypes()) {
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(importString, this.processor, log));
                }
                this.supportedOptionNames = new ArrayList();
                for (String optionName : this.processor.getSupportedOptions()) {
                    if (!this.checkOptionName(optionName, log)) continue;
                    this.supportedOptionNames.add(optionName);
                }
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion procSourceVersion = this.processor.getSupportedSourceVersion();
            if (procSourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning("proc.processor.incompatible.source.version", new Object[]{procSourceVersion, this.processor.getClass().getName(), source.name});
            }
        }

        private boolean checkOptionName(String optionName, Log log) {
            boolean valid = JavacProcessingEnvironment.isValidOptionName(optionName);
            if (!valid) {
                log.error("proc.processor.bad.option.name", optionName, this.processor.getClass().getName());
            }
            return valid;
        }

        public boolean annotationSupported(String annotationName) {
            for (Pattern p : this.supportedAnnotationPatterns) {
                if (!p.matcher(annotationName).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> unmatchedProcessorOptions) {
            unmatchedProcessorOptions.removeAll(this.supportedOptionNames);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String names, ClassLoader processorCL, Log log) {
            this.names = Arrays.asList(names.split(",")).iterator();
            this.processorCL = processorCL;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            Processor processor;
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            String processorName = this.names.next();
            try {
                try {
                    processor = (Processor)this.processorCL.loadClass(processorName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.error("proc.processor.not.found", processorName);
                    return false;
                }
                catch (ClassCastException cce) {
                    this.log.error("proc.processor.wrong.type", processorName);
                    return false;
                }
                catch (Exception e) {
                    this.log.error("proc.processor.cant.instantiate", processorName);
                    return false;
                }
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
            this.nextProc = processor;
            return true;
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor p = this.nextProc;
                this.nextProc = null;
                return p;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

