/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jolokia.restrictor.policy.AbstractChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CorsChecker
extends AbstractChecker<String> {
    private boolean strictChecking = false;
    private List<Pattern> patterns;

    public CorsChecker(Document pDoc) {
        NodeList corsNodes = pDoc.getElementsByTagName("cors");
        if (corsNodes.getLength() > 0) {
            this.patterns = new ArrayList<Pattern>();
            for (int i = 0; i < corsNodes.getLength(); ++i) {
                Node corsNode = corsNodes.item(i);
                NodeList nodes = corsNode.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node node = nodes.item(j);
                    if (node.getNodeType() != 1) continue;
                    this.assertNodeName(node, "allow-origin", "strict-checking");
                    if (node.getNodeName().equals("allow-origin")) {
                        String p = node.getTextContent().trim().toLowerCase();
                        p = Pattern.quote(p).replace("*", "\\E.*\\Q");
                        this.patterns.add(Pattern.compile("^" + p + "$"));
                        continue;
                    }
                    if (!node.getNodeName().equals("strict-checking")) continue;
                    this.strictChecking = true;
                }
            }
        }
    }

    @Override
    public boolean check(String pArg) {
        return this.check(pArg, false);
    }

    public boolean check(String pOrigin, boolean pIsStrictCheck) {
        if (pIsStrictCheck && !this.strictChecking) {
            return true;
        }
        if (this.patterns == null || this.patterns.size() == 0) {
            return true;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(pOrigin).matches()) continue;
            return true;
        }
        return false;
    }
}

