/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent;

import java.util.concurrent.TimeoutException;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.api.ThreadingPolicy;
import org.jmock.internal.StatePredicate;
import org.jmock.lib.concurrent.internal.FixedTimeout;
import org.jmock.lib.concurrent.internal.InfiniteTimeout;
import org.jmock.lib.concurrent.internal.Timeout;
import org.junit.Assert;

public class Synchroniser
implements ThreadingPolicy {
    private final Object sync = new Object();
    private Error firstError = null;

    public void waitUntil(StatePredicate p) throws InterruptedException {
        this.waitUntil(p, new InfiniteTimeout());
    }

    public void waitUntil(StatePredicate p, long timeoutMs) throws InterruptedException {
        this.waitUntil(p, new FixedTimeout(timeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntil(StatePredicate p, Timeout timeout) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            while (!p.isActive()) {
                try {
                    this.sync.wait(timeout.timeRemaining());
                }
                catch (TimeoutException e) {
                    if (this.firstError != null) {
                        throw this.firstError;
                    }
                    Assert.fail((String)("timed out waiting for " + StringDescription.asString((SelfDescribing)p)));
                }
            }
        }
    }

    public Invokable synchroniseAccessTo(final Invokable mockObject) {
        return new Invokable(){

            public Object invoke(Invocation invocation) throws Throwable {
                return Synchroniser.this.synchroniseInvocation(mockObject, invocation);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object synchroniseInvocation(Invokable mockObject, Invocation invocation) throws Throwable {
        Object object = this.sync;
        synchronized (object) {
            try {
                Object object2 = mockObject.invoke(invocation);
                return object2;
            }
            catch (Error e) {
                if (this.firstError == null) {
                    this.firstError = e;
                }
                throw e;
            }
            finally {
                this.sync.notifyAll();
            }
        }
    }
}

