/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = 656782657242515455L;

    public static <E> EventImpl<E> of(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        return new EventImpl(EventImpl.getFacadeType(injectionPoint), EventImpl.getFacadeEventQualifiers(injectionPoint), injectionPoint, beanManager);
    }

    private static Annotation[] getFacadeEventQualifiers(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(Default.class)) {
            HashSet qualifers = new HashSet(injectionPoint.getQualifiers());
            qualifers.remove(DefaultLiteral.INSTANCE);
            return qualifers.toArray(Reflections.EMPTY_ANNOTATIONS);
        }
        return injectionPoint.getQualifiers().toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    private EventImpl(Type type, Annotation[] qualifiers, InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        super(type, qualifiers, injectionPoint, beanManager);
    }

    @Override
    public String toString() {
        return Names.annotationsToString(this.getQualifiers()) + " Event<" + this.getType() + ">";
    }

    public void fire(T event) {
        this.getBeanManager().fireEvent(event, this.getQualifiers());
    }

    public Event<T> select(Annotation ... qualifiers) {
        return this.selectEvent(this.getType(), qualifiers);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype, qualifiers);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype.getType(), qualifiers);
    }

    private <U extends T> Event<U> selectEvent(Type subtype, Annotation[] newQualifiers) {
        Observers.checkEventObjectType(subtype);
        return new EventImpl<T>(subtype, Beans.mergeInQualifiers(this.getQualifiers(), newQualifiers), this.getInjectionPoint(), this.getBeanManager());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(EventMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy
    extends AbstractFacade.AbstractFacadeSerializationProxy {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(EventImpl<?> event) {
            super(event);
        }

        private Object readResolve() {
            return EventImpl.of(this.getInjectionPoint(), this.getBeanManager());
        }
    }
}

