/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.EventBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.bean.builtin.InstanceBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorFactoryBean;
import org.jboss.weld.bean.builtin.ee.PrincipalBean;
import org.jboss.weld.bean.builtin.ee.UserTransactionBean;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jboss.weld.xml.BeansXmlParser;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployment {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final BeanDeployer beanDeployer;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.beanDeploymentArchive = beanDeploymentArchive;
        EjbDescriptors ejbDescriptors = new EjbDescriptors();
        beanDeploymentArchive.getServices().add(EjbDescriptors.class, (Service)ejbDescriptors);
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll((Collection)deploymentServices.entrySet());
        services.addAll((Collection)beanDeploymentArchive.getServices().entrySet());
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, beanDeploymentArchive.getId(), (ServiceRegistry)services);
        if (this.beanManager.getServices().contains(EjbServices.class)) {
            ejbDescriptors.addAll(beanDeploymentArchive.getEjbs());
        }
        this.beanDeployer = new BeanDeployer(this.beanManager, ejbDescriptors);
        this.beanManager.addBean(new BeanManagerBean(this.beanManager));
        this.parseBeansXml();
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    private void parseBeansXml() {
        BeansXmlParser parser = new BeansXmlParser((ResourceLoader)this.beanManager.getServices().get(ResourceLoader.class), this.getBeanDeploymentArchive().getBeansXml());
        parser.parse();
        if (parser.getEnabledAlternativeClasses() != null) {
            this.beanManager.setEnabledAlternativeClasses(parser.getEnabledAlternativeClasses());
        }
        if (parser.getEnabledAlternativeStereotypes() != null) {
            this.beanManager.setEnabledAlternativeStereotypes(parser.getEnabledAlternativeStereotypes());
        }
        if (parser.getEnabledDecoratorClasses() != null) {
            this.beanManager.setEnabledDecoratorClasses(parser.getEnabledDecoratorClasses());
        }
        if (parser.getEnabledInterceptorClasses() != null) {
            this.beanManager.setEnabledInterceptorClasses(parser.getEnabledInterceptorClasses());
        }
        log.debug((Enum)BootstrapMessage.ENABLED_ALTERNATIVES, new Object[]{this.beanManager, this.beanManager.getEnabledAlternativeClasses(), this.beanManager.getEnabledAlternativeStereotypes()});
        log.debug((Enum)BootstrapMessage.ENABLED_DECORATORS, new Object[]{this.beanManager, this.beanManager.getEnabledDecoratorClasses()});
        log.debug((Enum)BootstrapMessage.ENABLED_INTERCEPTORS, new Object[]{this.beanManager, this.beanManager.getEnabledInterceptorClasses()});
    }

    public void deployBeans(Environment environment) {
        this.beanDeployer.addClasses(this.beanDeploymentArchive.getBeanClasses());
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InjectionPointBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new EventBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InstanceBean(this.beanManager));
        if (this.beanManager.getServices().contains(TransactionServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new UserTransactionBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(SecurityServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new PrincipalBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(ValidationServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorBean(this.beanManager));
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorFactoryBean(this.beanManager));
        }
        this.beanDeployer.createBeans().deploy();
    }

    public void afterBeanDiscovery(Environment environment) {
        this.doAfterBeanDiscovery(this.beanManager.getBeans());
        this.doAfterBeanDiscovery(this.beanManager.getDecorators());
        this.doAfterBeanDiscovery(this.beanManager.getInterceptors());
    }

    private void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }
}

