/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.util.Map;
import java.util.TreeMap;
import org.javaswift.joss.client.core.AbstractAccount;
import org.javaswift.joss.client.core.ContainerFactory;
import org.javaswift.joss.model.Container;

public class ContainerCache<N extends Container> {
    private Map<String, N> cache = new TreeMap<String, N>();
    private final AbstractAccount account;
    private final ContainerFactory<N> containerFactory;
    private boolean cacheEnabled;

    public ContainerCache(AbstractAccount account, ContainerFactory<N> containerFactory) {
        this.account = account;
        this.containerFactory = containerFactory;
        this.cacheEnabled = true;
    }

    public N getContainer(String containerName) {
        if (!this.cacheEnabled) {
            return this.containerFactory.create(this.account, containerName);
        }
        Container container = (Container)this.cache.get(containerName);
        if (container == null) {
            container = this.containerFactory.create(this.account, containerName);
            this.cache.put(containerName, container);
        }
        return (N)container;
    }

    public void reset() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

