/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.exception.NotFoundException;
import org.javaswift.joss.headers.Metadata;
import org.javaswift.joss.information.AbstractInformation;
import org.javaswift.joss.model.ObjectStoreEntity;

public abstract class AbstractObjectStoreEntity<I extends AbstractInformation>
implements ObjectStoreEntity {
    protected static final boolean ALLOW_CACHING = true;
    protected I info;
    private boolean allowCaching = true;
    private boolean stale = true;
    protected boolean staleHeaders = true;

    public AbstractObjectStoreEntity(boolean allowCaching) {
        this.allowCaching = allowCaching;
    }

    @Override
    public void setMetadata(Map<String, Object> metadata) {
        ((AbstractInformation)this.info).clear();
        for (String key : metadata.keySet()) {
            this.setAndDoNotSaveMetadata(key, metadata.get(key));
        }
        this.saveMetadata();
    }

    @Override
    public void setAndSaveMetadata(String key, Object value) {
        this.setAndDoNotSaveMetadata(key, value);
        this.saveMetadata();
    }

    @Override
    public void setAndDoNotSaveMetadata(String key, Object value) {
        ((AbstractInformation)this.info).addMetadata(this.createMetadataEntry(key, value.toString()));
    }

    @Override
    public void removeAndSaveMetadata(String key) {
        this.setAndSaveMetadata(key, "");
    }

    @Override
    public void removeAndDoNotSaveMetadata(String key) {
        this.setAndDoNotSaveMetadata(key, "");
    }

    protected abstract Metadata createMetadataEntry(String var1, String var2);

    @Override
    public void saveMetadata() {
        this.saveSpecificMetadata();
        this.invalidate();
    }

    protected abstract void saveSpecificMetadata();

    @Override
    public Object getMetadata(String key) {
        return this.getMetadata().get(Metadata.capitalize(key));
    }

    @Override
    public Map<String, Object> getMetadata() {
        this.checkForInfo();
        TreeMap<String, Object> metadataValues = new TreeMap<String, Object>();
        for (Metadata metadata : ((AbstractInformation)this.info).getMetadata()) {
            metadataValues.put(metadata.getName(), metadata.getHeaderValue());
        }
        return metadataValues;
    }

    protected void checkForInfoAndAllowHeaderSet() {
        this.checkForInfo(true, true);
    }

    protected void checkForInfo() {
        this.checkForInfo(false, true);
    }

    protected void checkForInfoDisallowErrorLog() {
        this.checkForInfo(false, false);
    }

    protected void checkForInfo(boolean readHeader, boolean allowErrorLog) {
        if (this.isStale(readHeader)) {
            this.getInfo(allowErrorLog);
            this.setInfoRetrieved();
        }
    }

    protected void setInfoRetrieved() {
        this.stale = false;
    }

    public boolean exists() {
        try {
            this.invalidate();
            this.checkForInfoDisallowErrorLog();
        }
        catch (NotFoundException err) {
            return false;
        }
        return true;
    }

    public void invalidate() {
        this.stale = true;
        this.staleHeaders = true;
    }

    public boolean isStale(boolean readHeader) {
        if (!this.isAllowCaching()) {
            return true;
        }
        if (readHeader) {
            return this.stale && this.staleHeaders;
        }
        return this.stale;
    }

    public boolean isAllowCaching() {
        return this.allowCaching;
    }

    public void reload() {
        this.invalidate();
        this.checkForInfo();
    }

    public boolean isInfoRetrieved() {
        return !this.stale;
    }

    @Override
    public String getPath() {
        try {
            return this.getPathForEntity();
        }
        catch (Exception e) {
            throw new CommandException("Unable to encode the object path");
        }
    }

    public abstract String getPathForEntity() throws UnsupportedEncodingException;

    protected abstract void getInfo(boolean var1);
}

