/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.rules;

import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.flowable.engine.common.EngineDeployer;
import org.flowable.engine.common.api.repository.EngineDeployment;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing rules deployment {}", (Object)deployment.getName());
        KnowledgeBuilder knowledgeBuilder = null;
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".drl")) continue;
            LOGGER.info("Processing rules resource {}", (Object)resourceName);
            if (knowledgeBuilder == null) {
                knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            }
            EngineResource resourceEntity = (EngineResource)resources.get(resourceName);
            byte[] resourceBytes = resourceEntity.getBytes();
            Resource droolsResource = ResourceFactory.newByteArrayResource((byte[])resourceBytes);
            knowledgeBuilder.add(droolsResource, ResourceType.DRL);
        }
        if (knowledgeBuilder != null) {
            KnowledgeBase knowledgeBase = knowledgeBuilder.newKnowledgeBase();
            deploymentManager.getKnowledgeBaseCache().add(deployment.getId(), (Object)knowledgeBase);
        }
    }
}

