/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableUpdatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "variable-updated";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return CommandContextUtil.getHistoricVariableService().getHistoricVariableInstance(this.getStringFromJson(historicalData, "id")) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableInstanceEntity historicVariable = CommandContextUtil.getHistoricVariableService().getHistoricVariableInstance(this.getStringFromJson(historicalData, "id"));
        Date time = this.getDateFromJson(historicalData, "lastUpdatedTime");
        if (historicVariable.getLastUpdatedTime().after(time)) {
            return;
        }
        VariableTypes variableTypes = CommandContextUtil.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(this.getStringFromJson(historicalData, "variableType"));
        historicVariable.setVariableType(variableType);
        historicVariable.setTextValue(this.getStringFromJson(historicalData, "variableTextValue"));
        historicVariable.setTextValue2(this.getStringFromJson(historicalData, "variableTextValue2"));
        historicVariable.setDoubleValue(this.getDoubleFromJson(historicalData, "variableDoubleValue"));
        historicVariable.setLongValue(this.getLongFromJson(historicalData, "variableLongValue"));
        String variableBytes = this.getStringFromJson(historicalData, "variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariable.setBytes(Base64.decodeBase64((String)variableBytes));
        }
        historicVariable.setLastUpdatedTime(time);
    }
}

