/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPropertyChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPropertyChangedHistoryJsonTransformer.class);

    @Override
    public String getType() {
        return "task-property-changed";
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId = this.getStringFromJson(historicalData, "id");
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            HistoricTaskInstanceEntity historicTaskInstance = CommandContextUtil.getHistoricTaskService().getHistoricTask(taskId);
            Date lastUpdateTime = this.getDateFromJson(historicalData, "__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
                historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
                historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
                historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
                historicTaskInstance.setClaimTime(this.getDateFromJson(historicalData, "claimTime"));
                historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
                historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority").intValue());
                historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
                historicTaskInstance.setFormKey(this.getStringFromJson(historicalData, "formKey"));
                historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
                historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
                historicTaskInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("History job (id={}) has expired and will be ignored.", (Object)job.getId());
            }
        }
    }
}

